/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.db2client.impl.drda;

import io.netty.buffer.ByteBuf;
import io.vertx.db2client.impl.drda.DB2RowId;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.RowId;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.UUID;

public class ClientTypes {
    public static final int BIT = -7;
    public static final int BOOLEAN = 16;
    public static final int SMALLINT = 5;
    public static final int INTEGER = 4;
    public static final int BIGINT = -5;
    public static final int REAL = 7;
    public static final int DOUBLE = 8;
    public static final int DECIMAL = 3;
    public static final int CHAR = 1;
    public static final int VARCHAR = 12;
    public static final int LONGVARCHAR = -1;
    public static final int DATE = 91;
    public static final int TIME = 92;
    public static final int TIMESTAMP = 93;
    public static final int BINARY = -2;
    public static final int VARBINARY = -3;
    public static final int LONGVARBINARY = -4;
    public static final int BLOB = 2004;
    public static final int CLOB = 2005;
    public static final int JAVA_OBJECT = 2000;
    public static final int ROWID = -8;

    private ClientTypes() {
    }

    public static String getTypeString(int type) {
        switch (type) {
            case -5: {
                return "BIGINT";
            }
            case -2: {
                return "BINARY";
            }
            case 2004: {
                return "BLOB";
            }
            case -7: 
            case 16: {
                return "BOOLEAN";
            }
            case 1: {
                return "CHAR";
            }
            case 2005: {
                return "CLOB";
            }
            case 91: {
                return "DATE";
            }
            case 3: {
                return "DECIMAL";
            }
            case 8: {
                return "DOUBLE";
            }
            case 4: {
                return "INTEGER";
            }
            case -4: {
                return "LONGVARBINARY";
            }
            case -1: {
                return "LONGVARCHAR";
            }
            case 7: {
                return "REAL";
            }
            case 5: {
                return "SMALLINT";
            }
            case 92: {
                return "TIME";
            }
            case 93: {
                return "TIMESTAMP";
            }
            case -3: {
                return "VARBINARY";
            }
            case 12: {
                return "VARCHAR";
            }
            case -8: {
                return "ROWID";
            }
            case 2003: {
                return "ARRAY";
            }
            case 70: {
                return "DATALINK";
            }
            case 2006: {
                return "REF";
            }
            case 2009: {
                return "SQLXML";
            }
            case 2002: {
                return "STRUCT";
            }
        }
        return "UNKNOWN(" + type + ")";
    }

    public static Class<?> preferredJavaType(int clientType) {
        switch (clientType) {
            case -5: {
                return BigInteger.class;
            }
            case -4: 
            case -3: 
            case -2: {
                return ByteBuf.class;
            }
            case -7: {
                return Boolean.class;
            }
            case 2004: {
                return ByteBuf.class;
            }
            case 16: {
                return Boolean.class;
            }
            case -1: 
            case 1: 
            case 12: {
                return String.class;
            }
            case 2005: {
                return String.class;
            }
            case 91: {
                return LocalDate.class;
            }
            case 3: {
                return BigDecimal.class;
            }
            case 8: {
                return Double.class;
            }
            case 4: {
                return Integer.class;
            }
            case 7: {
                return Float.class;
            }
            case -8: {
                return DB2RowId.class;
            }
            case 5: {
                return Short.class;
            }
            case 92: {
                return LocalTime.class;
            }
            case 93: {
                return LocalDateTime.class;
            }
        }
        throw new IllegalArgumentException("Unknown client type: " + clientType);
    }

    public static int mapDB2TypeToDriverType(boolean isDescribed, int sqlType, long length, int ccsid) {
        switch (sqlType & 0xFFFFFFFE) {
            case 2436: {
                return 16;
            }
            case 500: {
                return 5;
            }
            case 496: {
                return 4;
            }
            case 492: {
                return -5;
            }
            case 480: {
                if (length == 16L) {
                    return 3;
                }
                if (length == 8L) {
                    return 8;
                }
                if (length == 4L) {
                    return 7;
                }
                return 0;
            }
            case 484: 
            case 504: {
                return 3;
            }
            case 452: {
                if (isDescribed && (ccsid == 65535 || ccsid == 0)) {
                    return -2;
                }
                return 1;
            }
            case 460: {
                return 1;
            }
            case 448: {
                if (isDescribed && (ccsid == 65535 || ccsid == 0)) {
                    return -3;
                }
                return 12;
            }
            case 456: {
                if (isDescribed && (ccsid == 65535 || ccsid == 0)) {
                    return -4;
                }
                return -1;
            }
            case 384: {
                return 91;
            }
            case 388: {
                return 92;
            }
            case 392: {
                return 93;
            }
            case 408: {
                return 2005;
            }
            case 404: {
                return 2004;
            }
            case 2000: {
                return 2000;
            }
            case 904: {
                return -8;
            }
        }
        return 0;
    }

    public static boolean canConvert(Object value, int toType) {
        if (value == null) {
            return true;
        }
        Class<?> clazz = value.getClass();
        switch (toType) {
            case -5: 
            case 4: {
                return clazz == Boolean.TYPE || clazz == Boolean.class || clazz == Double.TYPE || clazz == Double.class || clazz == Float.TYPE || clazz == Float.class || clazz == Integer.TYPE || clazz == Integer.class || clazz == Long.TYPE || clazz == Long.class || clazz == Short.TYPE || clazz == Short.class || clazz == BigDecimal.class || clazz == BigInteger.class;
            }
            case 3: 
            case 7: 
            case 8: {
                return clazz == Double.TYPE || clazz == Double.class || clazz == Float.TYPE || clazz == Float.class || clazz == Integer.TYPE || clazz == Integer.class || clazz == Long.TYPE || clazz == Long.class || clazz == Short.TYPE || clazz == Short.class || clazz == BigDecimal.class || clazz == BigInteger.class;
            }
            case -7: 
            case 5: 
            case 16: {
                return clazz == Boolean.TYPE || clazz == Boolean.class || clazz == Character.TYPE || clazz == Character.class || clazz == Integer.TYPE || clazz == Integer.class || clazz == Long.TYPE || clazz == Long.class || clazz == Short.TYPE || clazz == Short.class || clazz == Byte.TYPE || clazz == Byte.class || clazz == BigDecimal.class;
            }
            case -2: {
                return clazz == Boolean.TYPE || clazz == Boolean.class || clazz == Byte.TYPE || clazz == Byte.class || clazz == byte[].class;
            }
            case 91: {
                return clazz == LocalDate.class || clazz == Date.class || clazz == String.class;
            }
            case 92: {
                return clazz == LocalTime.class || clazz == Time.class || clazz == String.class;
            }
            case 93: {
                return clazz == LocalDateTime.class || clazz == Timestamp.class || clazz == String.class;
            }
            case 1: {
                return clazz == Character.TYPE || clazz == Character.class || clazz == String.class;
            }
            case -1: 
            case 12: 
            case 2005: {
                return clazz == String.class || clazz == char[].class || clazz == UUID.class;
            }
            case -4: 
            case -3: 
            case 2004: {
                return clazz == byte[].class || ByteBuf.class.isAssignableFrom(clazz);
            }
            case -8: {
                return clazz == RowId.class || clazz == DB2RowId.class;
            }
        }
        return false;
    }
}

