/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.db2client.impl.codec;

import io.vertx.core.buffer.Buffer;
import io.vertx.db2client.impl.drda.ClientTypes;
import io.vertx.db2client.impl.drda.ColumnMetaData;
import io.vertx.sqlclient.data.Numeric;
import io.vertx.sqlclient.impl.ErrorMessageFactory;
import io.vertx.sqlclient.impl.ParamDesc;
import io.vertx.sqlclient.impl.TupleInternal;

class DB2ParamDesc
extends ParamDesc {
    private final ColumnMetaData paramDefinitions;

    DB2ParamDesc(ColumnMetaData paramDefinitions) {
        this.paramDefinitions = paramDefinitions;
    }

    ColumnMetaData paramDefinitions() {
        return this.paramDefinitions;
    }

    public String prepare(TupleInternal values) {
        if (values.size() != this.paramDefinitions.columns_) {
            return ErrorMessageFactory.buildWhenArgumentsLengthNotMatched((int)this.paramDefinitions.columns_, (int)values.size());
        }
        for (int i = 0; i < this.paramDefinitions.columns_; ++i) {
            int type;
            Object val = values.getValue(i);
            if (DB2ParamDesc.canConvert(val, type = this.paramDefinitions.types_[i])) continue;
            Class<?> preferredType = ClientTypes.preferredJavaType(type);
            return ErrorMessageFactory.buildWhenArgumentsTypeNotMatched(preferredType, (int)i, (Object)val);
        }
        return null;
    }

    private static boolean canConvert(Object val, int type) {
        if (val == null) {
            return true;
        }
        if (ClientTypes.canConvert(val, type)) {
            return true;
        }
        Class<?> clazz = val.getClass();
        switch (type) {
            case -5: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 16: {
                return clazz == Numeric.class;
            }
            case 12: {
                return Enum.class.isAssignableFrom(clazz) || Buffer.class.isAssignableFrom(clazz);
            }
            case -3: 
            case -2: {
                return Buffer.class.isAssignableFrom(clazz);
            }
        }
        return false;
    }
}

