/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.db2client.impl.codec;

import io.netty.buffer.ByteBuf;
import io.vertx.core.Handler;
import io.vertx.db2client.impl.codec.DB2Encoder;
import io.vertx.sqlclient.internal.command.CommandBase;
import io.vertx.sqlclient.internal.command.CommandResponse;

abstract class CommandCodec<R, C extends CommandBase<R>> {
    Handler<? super CommandResponse<R>> completionHandler;
    public Throwable failure;
    public R result;
    final C cmd;
    DB2Encoder encoder;

    CommandCodec(C cmd) {
        this.cmd = cmd;
    }

    abstract void decodePayload(ByteBuf var1, int var2);

    void encode(DB2Encoder encoder) {
        this.encoder = encoder;
    }

    ByteBuf allocateBuffer() {
        return this.encoder.chctx.alloc().ioBuffer();
    }

    ByteBuf allocateBuffer(int capacity) {
        return this.encoder.chctx.alloc().ioBuffer(capacity);
    }

    void sendPacket(ByteBuf packet, int payloadLength) {
        if (payloadLength >= 0xFFFFFF) {
            throw new UnsupportedOperationException("Sending split packets not implemented");
        }
        this.sendNonSplitPacket(packet);
    }

    void sendNonSplitPacket(ByteBuf packet) {
        this.encoder.chctx.writeAndFlush((Object)packet, this.encoder.chctx.voidPromise());
    }
}

