/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.db2client.spi;

import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.internal.CloseFuture;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.internal.VertxInternal;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.NetClientOptions;
import io.vertx.db2client.DB2ConnectOptions;
import io.vertx.db2client.impl.DB2ConnectionFactory;
import io.vertx.db2client.impl.DB2ConnectionImpl;
import io.vertx.db2client.impl.DB2ConnectionUriParser;
import io.vertx.db2client.impl.Db2PoolOptions;
import io.vertx.sqlclient.Pool;
import io.vertx.sqlclient.PoolOptions;
import io.vertx.sqlclient.SqlConnectOptions;
import io.vertx.sqlclient.SqlConnection;
import io.vertx.sqlclient.internal.Connection;
import io.vertx.sqlclient.internal.SqlConnectionInternal;
import io.vertx.sqlclient.internal.pool.CloseablePool;
import io.vertx.sqlclient.internal.pool.PoolImpl;
import io.vertx.sqlclient.spi.ConnectionFactory;
import io.vertx.sqlclient.spi.Driver;
import java.util.function.Supplier;

public class DB2Driver
implements Driver<DB2ConnectOptions> {
    private static final String SHARED_CLIENT_KEY = "__vertx.shared.db2client";
    public static final DB2Driver INSTANCE = new DB2Driver();

    public DB2ConnectOptions downcast(SqlConnectOptions connectOptions) {
        return connectOptions instanceof DB2ConnectOptions ? (DB2ConnectOptions)connectOptions : new DB2ConnectOptions(connectOptions);
    }

    public Pool newPool(Vertx vertx, Supplier<Future<DB2ConnectOptions>> databases, PoolOptions poolOptions, NetClientOptions transportOptions, Handler<SqlConnection> connectHandler, CloseFuture closeFuture) {
        VertxInternal vx = (VertxInternal)vertx;
        PoolImpl pool = poolOptions.isShared() ? (PoolImpl)vx.createSharedResource(SHARED_CLIENT_KEY, poolOptions.getName(), closeFuture, cf -> this.newPoolImpl(vx, connectHandler, databases, poolOptions, transportOptions, (CloseFuture)cf)) : this.newPoolImpl(vx, connectHandler, databases, poolOptions, transportOptions, closeFuture);
        return new CloseablePool(vx, closeFuture, (Pool)pool);
    }

    private PoolImpl newPoolImpl(VertxInternal vertx, Handler<SqlConnection> connectHandler, Supplier<Future<DB2ConnectOptions>> databases, PoolOptions options, NetClientOptions transportOptions, CloseFuture closeFuture) {
        boolean pipelinedPool = options instanceof Db2PoolOptions && ((Db2PoolOptions)options).isPipelined();
        ConnectionFactory<DB2ConnectOptions> factory = this.createConnectionFactory((Vertx)vertx, transportOptions);
        PoolImpl pool = new PoolImpl(vertx, (Driver)this, pipelinedPool, options, null, null, context -> factory.connect(context, (Future)databases.get()), connectHandler, closeFuture);
        pool.init();
        closeFuture.add(factory);
        return pool;
    }

    public DB2ConnectOptions parseConnectionUri(String uri) {
        JsonObject conf = DB2ConnectionUriParser.parse(uri, false);
        return conf == null ? null : new DB2ConnectOptions(conf);
    }

    public boolean acceptsOptions(SqlConnectOptions options) {
        return options instanceof DB2ConnectOptions || SqlConnectOptions.class.equals(options.getClass());
    }

    public ConnectionFactory<DB2ConnectOptions> createConnectionFactory(Vertx vertx, NetClientOptions transportOptions) {
        return new DB2ConnectionFactory((VertxInternal)vertx, transportOptions);
    }

    public SqlConnectionInternal wrapConnection(ContextInternal context, ConnectionFactory<DB2ConnectOptions> factory, Connection conn) {
        return new DB2ConnectionImpl(context, factory, conn);
    }
}

