/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.db2client.impl.codec;

import io.netty.buffer.ByteBuf;
import io.vertx.core.internal.logging.Logger;
import io.vertx.core.internal.logging.LoggerFactory;
import io.vertx.db2client.impl.codec.CommandCodec;
import io.vertx.db2client.impl.codec.DB2Encoder;
import io.vertx.db2client.impl.codec.DB2ParamDesc;
import io.vertx.db2client.impl.codec.DB2PreparedStatement;
import io.vertx.db2client.impl.codec.DB2RowDesc;
import io.vertx.db2client.impl.drda.ColumnMetaData;
import io.vertx.db2client.impl.drda.DRDAQueryRequest;
import io.vertx.db2client.impl.drda.DRDAQueryResponse;
import io.vertx.db2client.impl.drda.Section;
import io.vertx.sqlclient.internal.PreparedStatement;
import io.vertx.sqlclient.internal.command.CommandResponse;
import io.vertx.sqlclient.internal.command.PrepareStatementCommand;

class PrepareStatementCodec
extends CommandCodec<PreparedStatement, PrepareStatementCommand> {
    private static final Logger LOG = LoggerFactory.getLogger(PrepareStatementCodec.class);
    private CommandHandlerState commandHandlerState = CommandHandlerState.INIT;
    private ColumnMetaData paramDesc;
    private ColumnMetaData rowDesc;
    private Section section;

    PrepareStatementCodec(PrepareStatementCommand cmd) {
        super(cmd);
    }

    @Override
    void encode(DB2Encoder encoder) {
        super.encode(encoder);
        this.sendStatementPrepareCommand();
    }

    private void sendStatementPrepareCommand() {
        ByteBuf packet = this.allocateBuffer();
        int packetStartIdx = packet.writerIndex();
        DRDAQueryRequest prepareCommand = new DRDAQueryRequest(packet, this.encoder.socketConnection.connMetadata);
        this.section = this.encoder.socketConnection.connMetadata.sectionManager.getSection(((PrepareStatementCommand)this.cmd).sql());
        String dbName = this.encoder.socketConnection.connMetadata.databaseName;
        prepareCommand.writePrepareDescribeOutput(((PrepareStatementCommand)this.cmd).sql(), dbName, this.section);
        prepareCommand.writeDescribeInput(this.section, dbName);
        prepareCommand.completeCommand();
        int payloadLength = packet.writerIndex() - packetStartIdx;
        this.sendPacket(packet, payloadLength);
    }

    @Override
    void decodePayload(ByteBuf payload, int payloadLength) {
        switch (this.commandHandlerState) {
            case INIT: {
                DRDAQueryResponse response = new DRDAQueryResponse(payload, this.encoder.socketConnection.connMetadata);
                response.readPrepareDescribeInputOutput();
                this.rowDesc = response.getOutputColumnMetaData();
                this.paramDesc = response.getInputColumnMetaData();
                if (LOG.isDebugEnabled()) {
                    LOG.debug((Object)("Prepared parameters: " + String.valueOf(this.paramDesc)));
                }
                this.handleColumnDefinitionsDecodingCompleted();
                this.commandHandlerState = CommandHandlerState.COLUMN_DEFINITIONS_DECODING_COMPLETED;
                break;
            }
            default: {
                throw new IllegalStateException("Unknown state: " + String.valueOf((Object)this.commandHandlerState));
            }
        }
    }

    private void handleReadyForQuery() {
        this.completionHandler.handle((Object)CommandResponse.success((Object)new DB2PreparedStatement(((PrepareStatementCommand)this.cmd).sql(), new DB2ParamDesc(this.paramDesc), DB2RowDesc.create(this.rowDesc), this.section)));
    }

    private void resetIntermediaryResult() {
        this.commandHandlerState = CommandHandlerState.INIT;
        this.rowDesc = null;
        this.paramDesc = null;
        this.section = null;
    }

    private void handleColumnDefinitionsDecodingCompleted() {
        this.handleReadyForQuery();
        this.resetIntermediaryResult();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "@" + Integer.toHexString(this.hashCode()) + " sql=" + ((PrepareStatementCommand)this.cmd).sql() + ", section=" + this.section;
    }

    private static enum CommandHandlerState {
        INIT,
        HANDLING_PARAM_COLUMN_DEFINITION,
        PARAM_DEFINITIONS_DECODING_COMPLETED,
        HANDLING_COLUMN_COLUMN_DEFINITION,
        COLUMN_DEFINITIONS_DECODING_COMPLETED;

    }
}

