/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.db2client.impl.drda;

import io.netty.buffer.ByteBuf;
import io.vertx.db2client.impl.drda.CCSIDConstants;
import io.vertx.db2client.impl.drda.CodePoint;
import io.vertx.db2client.impl.drda.ConnectionMetaData;
import io.vertx.db2client.impl.drda.NetSqlca;
import io.vertx.db2client.impl.drda.Typdef;
import java.nio.charset.Charset;
import java.util.ArrayDeque;
import java.util.Deque;

public abstract class DRDAResponse {
    final ByteBuf buffer;
    final ConnectionMetaData metadata;
    Deque<Integer> ddmCollectionLenStack = new ArrayDeque<Integer>(4);
    int ddmScalarLen_ = 0;
    protected int dssLength_;
    boolean dssIsContinued_;
    private boolean dssIsChainedWithSameID_;
    private int dssCorrelationID_ = 1;
    protected int peekedLength_ = 0;
    int peekedCodePoint_ = -1;
    int peekedNumOfExtendedLenBytes_ = 0;
    static final int END_OF_COLLECTION = -1;
    static final int END_OF_SAME_ID_CHAIN = -2;
    static final int END_OF_BUFFER = -3;

    public DRDAResponse(ByteBuf buffer, ConnectionMetaData metadata) {
        this.buffer = buffer;
        this.metadata = metadata;
    }

    protected final void startSameIdChainParse() {
        this.readDssHeader();
    }

    protected final void endOfSameIdChainData() {
        if (!this.ddmCollectionLenStack.isEmpty()) {
            throw new IllegalStateException("SQLState.NET_COLLECTION_STACK_NOT_EMPTY");
        }
        if (this.dssLength_ != 0) {
            throw new IllegalStateException("SQLState.NET_DSS_NOT_ZERO " + this.dssLength_);
        }
        if (this.dssIsChainedWithSameID_) {
            throw new IllegalStateException("SQLState.NET_DSS_CHAINED_WITH_SAME_ID");
        }
    }

    void parseENDUOWRM() {
        boolean svrcodReceived = false;
        int svrcod = CodePoint.SVRCOD_INFO;
        boolean uowdspReceived = false;
        int uowdsp = 0;
        boolean rdbnamReceived = false;
        String rdbnam = null;
        this.parseLengthAndMatchCodePoint(8716);
        this.pushLengthOnCollectionStack();
        int peekCP = this.peekCodePoint();
        while (peekCP != -1) {
            boolean foundInPass = false;
            if (peekCP == 4425) {
                foundInPass = true;
                svrcodReceived = this.checkAndGetReceivedFlag(svrcodReceived);
                svrcod = this.parseSVRCOD(CodePoint.SVRCOD_WARNING, CodePoint.SVRCOD_WARNING);
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 8469) {
                foundInPass = true;
                uowdspReceived = this.checkAndGetReceivedFlag(uowdspReceived);
                uowdsp = this.parseUOWDSP();
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 8464) {
                foundInPass = true;
                rdbnamReceived = this.checkAndGetReceivedFlag(rdbnamReceived);
                rdbnam = this.parseRDBNAM(true);
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 4511) {
                foundInPass = true;
                this.parseRLSCONV();
                peekCP = this.peekCodePoint();
            }
            if (foundInPass) continue;
            DRDAResponse.throwUnknownCodepoint(peekCP);
        }
        this.popCollectionStack();
        if (!svrcodReceived) {
            DRDAResponse.throwMissingRequiredCodepoint("SVRCOD", 4425);
        }
        if (!uowdspReceived) {
            DRDAResponse.throwMissingRequiredCodepoint("UOWDSP", 8469);
        }
        if (uowdsp == 1) {
            // empty if block
        }
    }

    private int parseRLSCONV() {
        this.parseLengthAndMatchCodePoint(4511);
        int i = this.readUnsignedByte();
        if (i != 240 && i != 241 && i != 242) {
            throw new IllegalStateException("Unknown value for RLSCONV: " + Integer.toHexString(i));
        }
        return i;
    }

    String parseRDBNAM(boolean skip) {
        this.parseLengthAndMatchCodePoint(8464);
        if (skip) {
            this.skipBytes();
            return null;
        }
        return this.readString();
    }

    private int parseUOWDSP() {
        this.parseLengthAndMatchCodePoint(8469);
        int uowdsp = this.readUnsignedByte();
        if (uowdsp != 1 && uowdsp != 2) {
            this.doValnsprmSemantics(8469, uowdsp);
        }
        return uowdsp;
    }

    NetSqlca parseSQLCARD(NetSqlca[] rowsetSqlca) {
        this.parseLengthAndMatchCodePoint(9224);
        int ddmLength = this.getDdmLength();
        this.ensureBLayerDataInBuffer(ddmLength);
        NetSqlca netSqlca = this.parseSQLCARDrow(rowsetSqlca);
        this.adjustLengths(this.getDdmLength());
        return netSqlca;
    }

    NetSqlca parseSQLCAGRP(NetSqlca[] rowsetSqlca) {
        if (this.readFastUnsignedByte() == 255) {
            return null;
        }
        int sqlcode = this.readFastInt();
        byte[] sqlstate = this.readFastBytes(5);
        byte[] sqlerrproc = this.readFastBytes(8);
        NetSqlca netSqlca = null;
        netSqlca = new NetSqlca(sqlcode, sqlstate, sqlerrproc);
        this.parseSQLCAXGRP(netSqlca);
        netSqlca.setRowsetRowCount(this.parseSQLDIAGGRP(rowsetSqlca));
        return netSqlca;
    }

    private long parseSQLDIAGGRP(NetSqlca[] rowsetSqlca) {
        if (this.readFastUnsignedByte() == 255) {
            return 0L;
        }
        long row_count = this.parseSQLDIAGSTT(rowsetSqlca);
        this.parseSQLDIAGCI(rowsetSqlca);
        this.parseSQLDIAGCN();
        return row_count;
    }

    private void parseSQLDIAGCN() {
        if (this.readUnsignedByte() == 255) {
            return;
        }
        int num = this.parseFastSQLNUMROW();
        for (int i = 0; i < num; ++i) {
            this.parseSQLCNROW();
        }
    }

    private void parseSQLCNROW() {
        this.parseSQLCNGRP();
    }

    private void parseSQLCNGRP() {
        this.skipBytes(18);
        String sqlcnRDB = this.parseFastVCS();
        String sqlcnClass = this.parseFastVCS();
        String sqlcnAuthid = this.parseFastVCS();
    }

    int parseSQLNUMROW() {
        return this.parseSQLNUMGRP();
    }

    int parseFastSQLNUMROW() {
        return this.parseFastSQLNUMGRP();
    }

    private int parseSQLNUMGRP() {
        return this.readShort();
    }

    private int parseFastSQLNUMGRP() {
        return this.readFastShort();
    }

    private long parseSQLDIAGSTT(NetSqlca[] rowsetSqlca) {
        if (this.readFastUnsignedByte() == 255) {
            return 0L;
        }
        int sqldsFcod = this.readFastInt();
        int sqldsCost = this.readFastInt();
        int sqldsLrow = this.readFastInt();
        this.skipFastBytes(16);
        long sqldsRowc = this.readFastLong();
        this.skipFastBytes(24);
        return sqldsRowc;
    }

    private void parseSQLDIAGCI(NetSqlca[] rowsetSqlca) {
        if (this.readFastUnsignedByte() == 255) {
            return;
        }
        int num = this.parseFastSQLNUMROW();
        if (num == 0) {
            this.resetRowsetSqlca(rowsetSqlca, 0);
        }
        int lastRow = 1;
        for (int i = 0; i < num; ++i) {
            lastRow = this.parseSQLDCROW(rowsetSqlca, lastRow);
        }
        this.resetRowsetSqlca(rowsetSqlca, lastRow + 1);
    }

    private void resetRowsetSqlca(NetSqlca[] rowsetSqlca, int row) {
        int count = rowsetSqlca == null ? 0 : rowsetSqlca.length;
        for (int i = row; i < count; ++i) {
            rowsetSqlca[i] = null;
        }
    }

    private int parseSQLDCROW(NetSqlca[] rowsetSqlca, int lastRow) {
        return this.parseSQLDCGRP(rowsetSqlca, lastRow);
    }

    private int parseSQLDCGRP(NetSqlca[] rowsetSqlca, int lastRow) {
        int sqldcCode = this.readFastInt();
        String sqldcState = this.readFastString(5, CCSIDConstants.UTF8);
        int sqldcReason = this.readFastInt();
        int sqldcLinen = this.readFastInt();
        int sqldcRown = (int)this.readFastLong();
        if (sqldcCode == 20237) {
            rowsetSqlca[0] = new NetSqlca(sqldcCode, sqldcState, null);
        } else if (rowsetSqlca[sqldcRown] != null) {
            rowsetSqlca[sqldcRown].resetRowsetSqlca(sqldcCode, sqldcState);
        } else {
            rowsetSqlca[sqldcRown] = new NetSqlca(sqldcCode, sqldcState, null);
        }
        for (int i = lastRow + 1; i < sqldcRown; ++i) {
            rowsetSqlca[i] = null;
        }
        this.skipFastBytes(47);
        String sqldcRdb = this.parseFastVCS();
        this.parseSQLDCTOKS();
        String sqldcMsg = this.parseFastNVCMorNVCS();
        this.skipFastNVCMorNVCS();
        this.skipFastNVCMorNVCS();
        this.skipFastNVCMorNVCS();
        this.parseSQLDCXGRP();
        return sqldcRown;
    }

    int parseSVRCOD(int minSvrcod, int maxSvrcod) {
        this.parseLengthAndMatchCodePoint(4425);
        int svrcod = this.readUnsignedShort();
        if (svrcod != CodePoint.SVRCOD_INFO && svrcod != CodePoint.SVRCOD_WARNING && svrcod != CodePoint.SVRCOD_ERROR && svrcod != CodePoint.SVRCOD_SEVERE && svrcod != CodePoint.SVRCOD_ACCDMG && svrcod != CodePoint.SVRCOD_PRMDMG && svrcod != CodePoint.SVRCOD_SESDMG) {
            this.doValnsprmSemantics(4425, svrcod);
        }
        if (svrcod < minSvrcod || svrcod > maxSvrcod) {
            this.doValnsprmSemantics(4425, svrcod);
        }
        return svrcod;
    }

    void doValnsprmSemantics(int codePoint, int value) {
        this.doValnsprmSemantics(codePoint, Integer.toString(value));
    }

    void doValnsprmSemantics(int codePoint, String value) {
        if (codePoint == 5242) {
            throw new IllegalStateException("SQLState.DRDA_DDM_PARAMVAL_NOT_SUPPORTED codePoint=" + Integer.toHexString(codePoint));
        }
        if (codePoint == 4508 || codePoint == 4509 || codePoint == 4510) {
            int cpValue = 0;
            switch (codePoint) {
                case 4508: {
                    cpValue = Typdef.typdef.getCcsidSbc();
                    break;
                }
                case 4509: {
                    cpValue = Typdef.typdef.getCcsidDbc();
                    break;
                }
                case 4510: {
                    cpValue = Typdef.typdef.getCcsidSbc();
                    break;
                }
            }
            throw new IllegalStateException("SQLState.DRDA_NO_AVAIL_CODEPAGE_CONVERSION");
        }
        throw new IllegalStateException("SQLState.DRDA_DDM_PARAMVAL_NOT_SUPPORTED");
    }

    private void parseSQLDCXGRP() {
        if (this.readFastUnsignedByte() == 255) {
            return;
        }
        this.skipFastNVCMorNVCS();
        this.skipFastNVCMorNVCS();
        this.skipFastNVCMorNVCS();
        this.skipFastNVCMorNVCS();
        String sqldcxCrdb = this.parseFastVCS();
        this.skipFastNVCMorNVCS();
        this.skipFastNVCMorNVCS();
        this.parseFastVCS();
        this.skipFastNVCMorNVCS();
        this.skipFastNVCMorNVCS();
        this.parseFastVCS();
        this.skipFastNVCMorNVCS();
        this.skipFastNVCMorNVCS();
    }

    private String parseFastNVCMorNVCS() {
        int vcs_length;
        String stringToBeSet = null;
        if (this.readFastUnsignedByte() != 255) {
            int vcm_length = this.readFastUnsignedShort();
            if (vcm_length > 0) {
                stringToBeSet = this.readFastString(vcm_length, Typdef.targetTypdef.getCcsidMbcEncoding());
            }
            if (this.readFastUnsignedByte() != 255) {
                throw new IllegalStateException("SQLState.NET_NVCM_NVCS_BOTH_NON_NULL");
            }
        } else if (this.readFastUnsignedByte() != 255 && (vcs_length = this.readFastUnsignedShort()) > 0) {
            stringToBeSet = this.readFastString(vcs_length, Typdef.targetTypdef.getCcsidSbcEncoding());
        }
        return stringToBeSet;
    }

    private void parseSQLDCTOKS() {
        if (this.readFastUnsignedByte() == 255) {
            return;
        }
        int num = this.parseFastSQLNUMROW();
        for (int i = 0; i < num; ++i) {
            this.parseSQLTOKROW();
        }
    }

    private void parseSQLTOKROW() {
        this.parseSQLTOKGRP();
    }

    private void parseSQLTOKGRP() {
        this.skipFastNVCMorNVCS();
    }

    private void skipFastNVCMorNVCS() {
        int vcs_length;
        if (this.readFastUnsignedByte() != 255) {
            int vcm_length = this.readFastUnsignedShort();
            if (vcm_length > 0) {
                this.skipFastBytes(vcm_length);
            }
            if (this.readFastUnsignedByte() != 255) {
                throw new IllegalStateException("SQLState.NET_NVCM_NVCS_BOTH_NON_NULL");
            }
        } else if (this.readFastUnsignedByte() != 255 && (vcs_length = this.readFastUnsignedShort()) > 0) {
            this.skipFastBytes(vcs_length);
        }
    }

    private void parseSQLCAXGRP(NetSqlca netSqlca) {
        if (this.readFastUnsignedByte() == 255) {
            netSqlca.setContainsSqlcax(false);
            return;
        }
        int[] sqlerrd = new int[6];
        this.readFastIntArray(sqlerrd);
        byte[] sqlwarn = this.readFastBytes(11);
        String string = this.parseFastVCS();
        byte[] sqlerrmc = this.readFastLDBytes();
        if (sqlerrmc != null) {
            int sqlerrmcCcsid = Typdef.targetTypdef.getCcsidMbc();
            this.skipFastBytes(2);
        } else {
            sqlerrmc = this.readFastLDBytes();
            int sqlerrmcCcsid = Typdef.targetTypdef.getCcsidSbc();
        }
        netSqlca.setSqlerrd(sqlerrd);
        netSqlca.setSqlwarnBytes(sqlwarn);
        netSqlca.setSqlerrmcBytes(sqlerrmc);
    }

    String parseFastVCMorVCS() {
        String stringToBeSet = null;
        int vcm_length = this.readFastUnsignedShort();
        if (vcm_length > 0) {
            stringToBeSet = this.readFastString(vcm_length, Typdef.targetTypdef.getCcsidMbcEncoding());
        }
        int vcs_length = this.readFastUnsignedShort();
        if (vcm_length > 0 && vcs_length > 0) {
            throw new IllegalStateException("SQLState.NET_VCM_VCS_LENGTHS_INVALID: VCM and VCS lengths are mutually exclusive but both were set: vcsLen=" + vcs_length + "  vcmLen=" + vcm_length);
        }
        if (vcs_length > 0) {
            stringToBeSet = this.readFastString(vcs_length, Typdef.targetTypdef.getCcsidSbcEncoding());
        }
        return stringToBeSet;
    }

    NetSqlca parseSQLCARDrow(NetSqlca[] rowsetSqlca) {
        return this.parseSQLCAGRP(rowsetSqlca);
    }

    int parseTypdefsOrMgrlvlovrs() {
        int peekCP;
        boolean targetTypedefCloned = false;
        while (true) {
            if ((peekCP = this.peekCodePoint()) == 47) {
                if (!targetTypedefCloned) {
                    targetTypedefCloned = true;
                }
                this.parseTYPDEFNAM();
                continue;
            }
            if (peekCP != 53) break;
            if (!targetTypedefCloned) {
                targetTypedefCloned = true;
            }
            this.parseTYPDEFOVR();
        }
        return peekCP;
    }

    void parseTYPDEFNAM() {
        this.parseLengthAndMatchCodePoint(47);
        String typedef = this.readString();
        Typdef.targetTypdef.setTypdefnam(typedef);
    }

    void parseTYPDEFOVR() {
        this.parseLengthAndMatchCodePoint(53);
        this.pushLengthOnCollectionStack();
        int peekCP = this.peekCodePoint();
        while (peekCP != -1) {
            boolean foundInPass = false;
            if (peekCP == 4508) {
                foundInPass = true;
                Typdef.targetTypdef.setCcsidSbc(this.parseCCSIDSBC());
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 4509) {
                foundInPass = true;
                Typdef.targetTypdef.setCcsidDbc(this.parseCCSIDDBC());
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 4510) {
                foundInPass = true;
                Typdef.targetTypdef.setCcsidMbc(this.parseCCSIDMBC());
                peekCP = this.peekCodePoint();
            }
            if (peekCP == 6419) {
                this.parseLengthAndMatchCodePoint(6419);
                this.readUnsignedShort();
                peekCP = this.peekCodePoint();
            }
            if (foundInPass) continue;
            DRDAResponse.throwUnknownCodepoint(peekCP);
        }
        this.popCollectionStack();
    }

    static void throwUnknownCodepoint(int codepoint) {
        throw new IllegalStateException("Found unknown codepoint: 0x" + Integer.toHexString(codepoint) + " / " + codepoint);
    }

    static void throwMissingRequiredCodepoint(String codepointStr, int expectedCodepoint) {
        throw new IllegalStateException("Did not find required " + codepointStr + " (" + Integer.toHexString(expectedCodepoint) + ") codepoint");
    }

    private int parseCCSIDSBC() {
        this.parseLengthAndMatchCodePoint(4508);
        return this.readUnsignedShort();
    }

    private int parseCCSIDMBC() {
        this.parseLengthAndMatchCodePoint(4510);
        return this.readUnsignedShort();
    }

    private int parseCCSIDDBC() {
        this.parseLengthAndMatchCodePoint(4509);
        return this.readUnsignedShort();
    }

    private void readDssHeader() {
        int nextCorrelationID;
        this.ensureALayerDataInBuffer(6);
        int oldDssLength = this.dssLength_ = this.buffer.readUnsignedShort();
        if ((this.dssLength_ & 0x8000) == 32768) {
            this.dssLength_ = Short.MAX_VALUE;
            this.dssIsContinued_ = true;
        } else {
            this.dssIsContinued_ = false;
        }
        if (this.dssLength_ < 6) {
            throw new IllegalStateException("DSS header length must be at least 6 bytes but was: " + this.dssLength_);
        }
        byte magic = this.buffer.readByte();
        if (magic != -48) {
            throw new IllegalStateException(String.format("Magic bit needs to be 0xD0 but was %02x", magic));
        }
        int gdsFormatter = this.buffer.readByte() & 0xFF;
        if ((gdsFormatter & 2) != 2 && (gdsFormatter & 3) != 3 && (gdsFormatter & 4) != 4) {
            throw new IllegalStateException("CodePoint.SYNERRCD_FBYTE_NOT_SUPPORTED");
        }
        if ((gdsFormatter & 0x40) == 64) {
            if ((gdsFormatter & 0x10) == 16) {
                this.dssIsChainedWithSameID_ = true;
                nextCorrelationID = this.dssCorrelationID_;
            } else {
                this.dssIsChainedWithSameID_ = false;
                nextCorrelationID = this.dssCorrelationID_ + 1;
            }
        } else {
            if ((gdsFormatter & 0x10) == 16) {
                throw new IllegalStateException("CodePoint.SYNERRCD_CHAIN_OFF_SAME_NEXT_CORRELATOR");
            }
            if ((gdsFormatter & 0x20) == 32) {
                throw new IllegalStateException("CodePoint.SYNERRCD_CHAIN_OFF_ERROR_CONTINUE");
            }
            this.dssIsChainedWithSameID_ = false;
            nextCorrelationID = 1;
        }
        short correlationID = this.buffer.readShort();
        if (correlationID != this.dssCorrelationID_ && correlationID != -1) {
            throw new IllegalStateException("Invalid correlator ID. Got " + correlationID + " expected " + this.dssCorrelationID_);
        }
        this.dssCorrelationID_ = nextCorrelationID;
        this.dssLength_ -= 6;
    }

    void readDSSContinuationHeader() {
        this.ensureALayerDataInBuffer(2);
        this.dssLength_ = this.buffer.readUnsignedShort();
        if ((this.dssLength_ & 0x8000) == 32768) {
            this.dssLength_ = Short.MAX_VALUE;
            this.dssIsContinued_ = true;
        } else {
            this.dssIsContinued_ = false;
        }
        if (this.dssLength_ <= 2) {
            this.doSyntaxrmSemantics(CodePoint.SYNERRCD_DSS_CONT_LESS_OR_EQUAL_2);
        }
        this.dssLength_ -= 2;
    }

    final String readString() {
        return this.readString(this.metadata.getCCSID());
    }

    final String readString(Charset encoding) {
        return this.readString(this.ddmScalarLen_, encoding);
    }

    final String readString(int length, Charset encoding) {
        this.ensureBLayerDataInBuffer(length);
        this.adjustLengths(length);
        String s = this.buffer.readCharSequence(length, encoding).toString();
        return s;
    }

    final short readShort() {
        this.ensureBLayerDataInBuffer(2);
        this.adjustLengths(2);
        if (this.metadata.isZos()) {
            return this.buffer.readShort();
        }
        return this.buffer.readShortLE();
    }

    boolean checkAndGetReceivedFlag(boolean receivedFlag) {
        if (receivedFlag) {
            this.doSyntaxrmSemantics(CodePoint.SYNERRCD_DUP_OBJ_PRESENT);
        }
        return true;
    }

    final void doSyntaxrmSemantics(int syntaxErrorCode) {
        throw new IllegalStateException("SQLState.DRDA_CONNECTION_TERMINATED CONN_DRDA_DATASTREAM_SYNTAX_ERROR " + syntaxErrorCode);
    }

    protected final int peekFastBytes(byte[] b, int offset, int length) {
        for (int i = 0; i < length; ++i) {
            b[offset + i] = this.buffer.getByte(this.buffer.readerIndex() + i);
        }
        return offset + length;
    }

    protected final int peekFastLength() {
        return this.buffer.getUnsignedShort(this.buffer.readerIndex());
    }

    protected final int peekCodePoint() {
        if (!this.ddmCollectionLenStack.isEmpty()) {
            if (this.ddmCollectionLenStack.peek() == 0) {
                return -1;
            }
            if (this.ddmCollectionLenStack.peek() < 4) {
                throw new IllegalStateException("Invalid ddm collection length: " + String.valueOf(this.ddmCollectionLenStack.peek()));
            }
        }
        if (this.dssLength_ == 0 && !this.dssIsContinued_) {
            if (!this.dssIsChainedWithSameID_) {
                return -2;
            }
            if (!this.buffer.isReadable()) {
                return -3;
            }
            this.readDssHeader();
        }
        this.peekedLength_ = this.buffer.getUnsignedShort(this.buffer.readerIndex());
        this.peekedCodePoint_ = this.buffer.getUnsignedShort(this.buffer.readerIndex() + 2);
        if ((this.peekedLength_ & 0x8000) == 32768) {
            this.peekExtendedLength();
        } else {
            this.peekedNumOfExtendedLenBytes_ = 0;
        }
        return this.peekedCodePoint_;
    }

    protected final void pushLengthOnCollectionStack() {
        this.ddmCollectionLenStack.push(this.ddmScalarLen_);
        this.ddmScalarLen_ = 0;
    }

    protected final void parseLengthAndMatchCodePoint(int expectedCodePoint) {
        int actualCodePoint = 0;
        if (this.peekedCodePoint_ == -1) {
            actualCodePoint = this.readLengthAndCodePoint();
        } else {
            actualCodePoint = this.peekedCodePoint_;
            this.buffer.readerIndex(this.buffer.readerIndex() + (4 + this.peekedNumOfExtendedLenBytes_));
            this.ddmScalarLen_ = this.peekedLength_;
            if (this.peekedNumOfExtendedLenBytes_ == 0 && this.ddmScalarLen_ != -1) {
                this.adjustLengths(4);
            } else {
                this.adjustCollectionAndDssLengths(4 + this.peekedNumOfExtendedLenBytes_);
            }
            this.peekedLength_ = 0;
            this.peekedCodePoint_ = -1;
            this.peekedNumOfExtendedLenBytes_ = 0;
        }
        if (actualCodePoint != expectedCodePoint) {
            throw new IllegalStateException("Expected code point " + Integer.toHexString(expectedCodePoint) + " but was " + Integer.toHexString(actualCodePoint));
        }
    }

    private int readLengthAndCodePoint() {
        if (!this.ddmCollectionLenStack.isEmpty()) {
            if (this.ddmCollectionLenStack.peek() == 0) {
                return -1;
            }
            if (this.ddmCollectionLenStack.peek() < 4) {
                throw new IllegalStateException("Invalid ddm collection length: " + String.valueOf(this.ddmCollectionLenStack.peek()));
            }
        }
        if (this.dssLength_ == 0 && !this.dssIsContinued_) {
            if (!this.dssIsChainedWithSameID_) {
                return -2;
            }
            this.readDssHeader();
        }
        this.ensureBLayerDataInBuffer(4);
        this.ddmScalarLen_ = this.buffer.readUnsignedShort();
        int codePoint = this.buffer.readUnsignedShort();
        this.adjustLengths(4);
        if ((this.ddmScalarLen_ & 0x8000) == 32768) {
            this.readExtendedLength();
        }
        return codePoint;
    }

    private void readExtendedLength() {
        int numberOfExtendedLenBytes = this.ddmScalarLen_ - 32768;
        int adjustSize = 0;
        switch (numberOfExtendedLenBytes) {
            case 4: {
                this.ensureBLayerDataInBuffer(4);
                this.ddmScalarLen_ = (int)this.buffer.readUnsignedInt();
                adjustSize = 4;
                break;
            }
            case 0: {
                this.ddmScalarLen_ = -1;
                adjustSize = 0;
                break;
            }
            default: {
                throw new IllegalStateException("CodePoint.SYNERRCD_INCORRECT_EXTENDED_LEN");
            }
        }
        this.adjustCollectionAndDssLengths(adjustSize);
    }

    private void adjustCollectionAndDssLengths(int length) {
        Deque<Integer> original = this.ddmCollectionLenStack;
        this.ddmCollectionLenStack = new ArrayDeque<Integer>(original.size());
        while (!original.isEmpty()) {
            this.ddmCollectionLenStack.add(original.pop() - length);
        }
        this.dssLength_ -= length;
        if (this.dssLength_ < 0) {
            throw new IllegalStateException("DSS length has gone negative: " + this.dssLength_);
        }
    }

    protected final void adjustLengths(int length) {
        this.ddmScalarLen_ -= length;
        if (this.ddmScalarLen_ < 0) {
            throw new IllegalStateException("DDM scalar length has gone negative: " + this.ddmScalarLen_);
        }
        this.adjustCollectionAndDssLengths(length);
    }

    protected int adjustDdmLength(int ddmLength, int length) {
        if ((ddmLength -= length) == 0) {
            this.adjustLengths(this.getDdmLength());
        }
        return ddmLength;
    }

    final int getDdmLength() {
        return this.ddmScalarLen_;
    }

    private void peekExtendedLength() {
        this.peekedNumOfExtendedLenBytes_ = this.peekedLength_ - 32772;
        switch (this.peekedNumOfExtendedLenBytes_) {
            case 4: {
                this.peekedLength_ = (int)this.buffer.getUnsignedInt(this.buffer.readerIndex() + 4);
                break;
            }
            case 0: {
                this.peekedLength_ = -1;
                break;
            }
            default: {
                throw new IllegalStateException("CodePoint.SYNERRCD_INCORRECT_EXTENDED_LEN");
            }
        }
    }

    final int[] readUnsignedShortList() {
        int len = this.ddmScalarLen_;
        this.ensureBLayerDataInBuffer(len);
        this.adjustLengths(len);
        int count = len / 2;
        int[] list = new int[count];
        for (int i = 0; i < count; ++i) {
            list[i] = this.buffer.readUnsignedShort();
        }
        return list;
    }

    final int readUnsignedByte() {
        this.ensureBLayerDataInBuffer(1);
        this.adjustLengths(1);
        return this.buffer.readUnsignedByte();
    }

    final byte readByte() {
        this.ensureBLayerDataInBuffer(1);
        this.adjustLengths(1);
        return this.buffer.readByte();
    }

    final byte[] readBytes(int length) {
        this.ensureBLayerDataInBuffer(length);
        this.adjustLengths(length);
        byte[] b = new byte[length];
        this.buffer.readBytes(b, 0, length);
        return b;
    }

    final byte[] readBytes() {
        int len = this.ddmScalarLen_;
        this.ensureBLayerDataInBuffer(len);
        this.adjustLengths(len);
        byte[] b = new byte[len];
        this.buffer.readBytes(b, 0, len);
        return b;
    }

    final int readUnsignedShort() {
        this.ensureBLayerDataInBuffer(2);
        this.adjustLengths(2);
        return this.buffer.readUnsignedShort();
    }

    String parseFastVCS() {
        return this.readFastString(this.readFastUnsignedShort(), Typdef.targetTypdef.getCcsidSbcEncoding());
    }

    final void skipBytes(int length) {
        this.ensureBLayerDataInBuffer(length);
        this.adjustLengths(length);
        this.buffer.skipBytes(length);
    }

    final void skipBytes() {
        int len = this.ddmScalarLen_;
        this.ensureBLayerDataInBuffer(len);
        this.adjustLengths(len);
        this.buffer.skipBytes(len);
    }

    final void skipFastBytes(int length) {
        this.buffer.skipBytes(length);
    }

    protected final void popCollectionStack() {
        this.ddmCollectionLenStack.pop();
    }

    final String readFastString(int length, Charset encoding) {
        return this.buffer.readCharSequence(length, encoding).toString();
    }

    final void readFastIntArray(int[] array) {
        for (int i = 0; i < array.length; ++i) {
            array[i] = this.metadata.isZos() ? this.buffer.readInt() : this.buffer.readIntLE();
        }
    }

    final int readFastUnsignedByte() {
        return this.buffer.readUnsignedByte();
    }

    final short readFastShort() {
        if (this.metadata.isZos()) {
            return this.buffer.readShort();
        }
        return this.buffer.readShortLE();
    }

    final long readFastLong() {
        if (this.metadata.isZos()) {
            return this.buffer.readLong();
        }
        return this.buffer.readLongLE();
    }

    final int readFastUnsignedShort() {
        return this.buffer.readUnsignedShort();
    }

    final int readFastInt() {
        if (this.metadata.isZos()) {
            return this.buffer.readInt();
        }
        return this.buffer.readIntLE();
    }

    final String readFastString(int length) {
        String result = this.buffer.readCharSequence(length, this.metadata.getCCSID()).toString();
        return result;
    }

    final byte[] readFastBytes(int length) {
        byte[] b = new byte[length];
        this.buffer.readBytes(b, 0, length);
        return b;
    }

    final byte[] readFastLDBytes() {
        short len = this.buffer.readShort();
        if (len == 0) {
            return null;
        }
        byte[] b = new byte[len];
        this.buffer.readBytes(b, 0, (int)len);
        return b;
    }

    void ensureBLayerDataInBuffer(int desiredDataSize) {
        this.ensureALayerDataInBuffer(desiredDataSize);
    }

    void ensureALayerDataInBuffer(int desiredDataSize) {
        if (this.buffer.readableBytes() < desiredDataSize) {
            throw new IllegalStateException("Needed to have " + desiredDataSize + " in buffer but only had " + this.buffer.readableBytes() + ". In JDBC we would normally block here but need to find a non-blocking solution");
        }
    }
}

