/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.db2client.impl.drda;

import io.vertx.db2client.impl.drda.DB2Package;
import io.vertx.db2client.impl.drda.Section;
import java.util.ArrayList;
import java.util.List;

public class SectionManager {
    private final List<DB2Package> pkgs = new ArrayList<DB2Package>(6);
    private final Section staticSection;

    SectionManager() {
        int i;
        for (i = 0; i < 3; ++i) {
            this.pkgs.add(new DB2Package(true, i));
        }
        for (i = 0; i < 3; ++i) {
            this.pkgs.add(new DB2Package(false, i));
        }
        this.staticSection = new Section.ImmediateSection(this.pkgs.get(3));
    }

    void configureForZOS() {
        this.pkgs.removeIf(DB2Package::isSmallPackage);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("SectionManager info:\n");
        for (DB2Package p : this.pkgs) {
            sb.append("  ").append(p).append("\n");
        }
        sb.append(this.staticSection);
        return sb.toString();
    }

    public int sectionsInUse() {
        return this.pkgs.stream().mapToInt(DB2Package::sectionsInUse).sum();
    }

    public Section getSection(String sql) {
        return this.getDynamicSection();
    }

    private Section getDynamicSection() {
        for (DB2Package p : this.pkgs) {
            Section s = p.getFreeSection();
            if (s == null) continue;
            return s;
        }
        throw new IllegalStateException("All sections are in use: " + String.valueOf(this));
    }
}

