/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.db2client;

import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.net.NetClientOptions;
import io.vertx.db2client.impl.Db2PoolOptions;
import io.vertx.db2client.spi.DB2Driver;
import io.vertx.sqlclient.ClientBuilder;
import io.vertx.sqlclient.Pool;
import io.vertx.sqlclient.PoolOptions;
import io.vertx.sqlclient.SqlClient;
import io.vertx.sqlclient.SqlConnectOptions;
import io.vertx.sqlclient.SqlConnection;
import io.vertx.sqlclient.impl.ClientBuilderBase;
import io.vertx.sqlclient.spi.Driver;
import java.util.function.Supplier;

@VertxGen
public interface DB2Builder {
    public static Pool pool(Handler<ClientBuilder<Pool>> block) {
        return ClientBuilder.pool((Driver)DB2Driver.INSTANCE, block);
    }

    public static ClientBuilder<Pool> pool() {
        return ClientBuilder.pool((Driver)DB2Driver.INSTANCE);
    }

    public static SqlClient client(Handler<ClientBuilder<SqlClient>> handler) {
        ClientBuilder<SqlClient> builder = DB2Builder.client();
        handler.handle(builder);
        return (SqlClient)builder.build();
    }

    public static ClientBuilder<SqlClient> client() {
        return new ClientBuilderBase<SqlClient>((Driver)DB2Driver.INSTANCE){

            public ClientBuilder<SqlClient> with(PoolOptions options) {
                if (options != null) {
                    options = new Db2PoolOptions(options).setPipelined(true);
                }
                return super.with(options);
            }

            protected SqlClient create(Vertx vertx, Supplier<Future<SqlConnectOptions>> databases, PoolOptions poolOptions, NetClientOptions transportOptions, Handler<SqlConnection> connectHandler) {
                return this.driver.createPool(vertx, databases, poolOptions, transportOptions, connectHandler);
            }
        };
    }
}

