/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.db2client.impl;

import io.vertx.core.Completable;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.internal.PromiseInternal;
import io.vertx.core.internal.VertxInternal;
import io.vertx.core.internal.net.NetSocketInternal;
import io.vertx.core.net.NetClientOptions;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.spi.metrics.ClientMetrics;
import io.vertx.core.spi.metrics.VertxMetrics;
import io.vertx.db2client.DB2ConnectOptions;
import io.vertx.db2client.impl.DB2ConnectionImpl;
import io.vertx.db2client.impl.DB2SocketConnection;
import io.vertx.sqlclient.SqlConnection;
import io.vertx.sqlclient.impl.ConnectionFactoryBase;
import io.vertx.sqlclient.internal.Connection;
import io.vertx.sqlclient.spi.ConnectionFactory;
import java.util.Map;
import java.util.function.Predicate;

public class DB2ConnectionFactory
extends ConnectionFactoryBase<DB2ConnectOptions> {
    public DB2ConnectionFactory(VertxInternal vertx) {
        super(vertx);
    }

    public DB2ConnectionFactory(VertxInternal vertx, NetClientOptions tcpOptions) {
        super(vertx, tcpOptions);
    }

    protected Future<Connection> doConnectInternal(DB2ConnectOptions options, ContextInternal context) {
        SocketAddress server = options.getSocketAddress();
        boolean cachePreparedStatements = options.getCachePreparedStatements();
        int preparedStatementCacheSize = options.getPreparedStatementCacheMaxSize();
        Predicate preparedStatementCacheSqlFilter = options.getPreparedStatementCacheSqlFilter();
        String username = options.getUser();
        String password = options.getPassword();
        String database = options.getDatabase();
        Map properties = options.getProperties();
        int pipeliningLimit = options.getPipeliningLimit();
        return this.client.connect(server).flatMap(so -> {
            VertxMetrics vertxMetrics = this.vertx.metrics();
            ClientMetrics metrics = vertxMetrics != null ? vertxMetrics.createClientMetrics(options.getSocketAddress(), "sql", options.getMetricsName()) : null;
            DB2SocketConnection conn = new DB2SocketConnection((NetSocketInternal)so, metrics, options, cachePreparedStatements, preparedStatementCacheSize, preparedStatementCacheSqlFilter, pipeliningLimit, context);
            conn.init();
            return Future.future(p -> conn.sendStartupMessage(username, password, database, properties, (Promise<Connection>)p));
        });
    }

    public Future<SqlConnection> connect(Context context, DB2ConnectOptions options) {
        ContextInternal contextInternal = (ContextInternal)context;
        PromiseInternal promise = contextInternal.promise();
        this.connect(DB2ConnectionFactory.asEventLoopContext((ContextInternal)contextInternal), options).map(conn -> {
            DB2ConnectionImpl db2Connection = new DB2ConnectionImpl(contextInternal, (ConnectionFactory)this, (Connection)conn);
            conn.init((Connection.Holder)db2Connection);
            return db2Connection;
        }).onComplete((Completable)promise);
        return promise.future();
    }
}

