/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.db2client.impl;

import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.internal.ContextInternal;
import io.vertx.db2client.DB2ConnectOptions;
import io.vertx.db2client.DB2Connection;
import io.vertx.db2client.impl.DB2ConnectionFactory;
import io.vertx.db2client.impl.command.PingCommand;
import io.vertx.db2client.spi.DB2Driver;
import io.vertx.sqlclient.internal.Connection;
import io.vertx.sqlclient.internal.SqlConnectionBase;
import io.vertx.sqlclient.spi.ConnectionFactory;
import io.vertx.sqlclient.spi.Driver;

public class DB2ConnectionImpl
extends SqlConnectionBase<DB2ConnectionImpl>
implements DB2Connection {
    public static Future<DB2Connection> connect(Vertx vertx, DB2ConnectOptions options) {
        DB2ConnectionFactory client;
        ContextInternal ctx = (ContextInternal)vertx.getOrCreateContext();
        try {
            client = new DB2ConnectionFactory(ctx.owner());
        }
        catch (Exception e) {
            return ctx.failedFuture((Throwable)e);
        }
        return DB2ConnectionImpl.prepareForClose((ContextInternal)ctx, client.connect((Context)ctx, options)).map(DB2Connection::cast);
    }

    public DB2ConnectionImpl(ContextInternal context, ConnectionFactory factory, Connection conn) {
        super(context, factory, conn, (Driver)DB2Driver.INSTANCE);
    }

    @Override
    public Future<Void> ping() {
        return this.schedule(this.context, new PingCommand());
    }

    @Override
    public Future<Void> debug() {
        throw new UnsupportedOperationException("Debug command not implemented");
    }
}

