/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.db2client.impl;

import io.vertx.core.buffer.Buffer;
import io.vertx.db2client.impl.drda.DB2RowId;
import io.vertx.sqlclient.data.Numeric;
import io.vertx.sqlclient.impl.RowBase;
import io.vertx.sqlclient.internal.RowDesc;
import java.sql.RowId;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.temporal.Temporal;
import java.util.List;
import java.util.UUID;

public class DB2RowImpl
extends RowBase {
    private final RowDesc rowDesc;

    public DB2RowImpl(RowDesc rowDesc) {
        super(rowDesc.columnNames().size());
        this.rowDesc = rowDesc;
    }

    public <T> T get(Class<T> type, int position) {
        if (type == Boolean.class) {
            return type.cast(this.getBoolean(position));
        }
        if (type == Byte.class) {
            return type.cast(this.getByte(position));
        }
        if (type == Short.class) {
            return type.cast(this.getShort(position));
        }
        if (type == Integer.class) {
            return type.cast(this.getInteger(position));
        }
        if (type == Long.class) {
            return type.cast(this.getLong(position));
        }
        if (type == Float.class) {
            return type.cast(this.getFloat(position));
        }
        if (type == Double.class) {
            return type.cast(this.getDouble(position));
        }
        if (type == Numeric.class) {
            return type.cast(this.getNumeric(position));
        }
        if (type == String.class) {
            return type.cast(this.getString(position));
        }
        if (type == Buffer.class) {
            return type.cast(this.getBuffer(position));
        }
        if (type == LocalDate.class) {
            return type.cast(this.getLocalDate(position));
        }
        if (type == LocalDateTime.class) {
            return type.cast(this.getLocalDateTime(position));
        }
        if (type == LocalTime.class) {
            return type.cast(this.getLocalTime(position));
        }
        if (type == Duration.class) {
            return type.cast(this.getDuration(position));
        }
        if (type == RowId.class || type == DB2RowId.class) {
            return type.cast(this.getRowId(position));
        }
        if (type == UUID.class) {
            return type.cast(this.getUUID(position));
        }
        if (type.isEnum()) {
            return type.cast(this.getEnum(type, position));
        }
        throw new UnsupportedOperationException("Unsupported type " + type.getName());
    }

    public String getColumnName(int pos) {
        List columnNames = this.rowDesc.columnNames();
        return pos < 0 || columnNames.size() - 1 < pos ? null : (String)columnNames.get(pos);
    }

    public int getColumnIndex(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        int idx = this.rowDesc.columnIndex(name);
        if (idx >= 0) {
            return idx;
        }
        return this.rowDesc.columnIndex(name.toUpperCase());
    }

    public Boolean getBoolean(int pos) {
        Object val = this.getValue(pos);
        if (val instanceof Boolean) {
            return (Boolean)val;
        }
        if (val instanceof Short) {
            return (Short)val != 0;
        }
        return null;
    }

    public RowId getRowId(int pos) {
        Object val = this.getValue(pos);
        if (val instanceof RowId) {
            return (RowId)val;
        }
        return null;
    }

    public RowId getRowId(String name) {
        int pos = this.getColumnIndex(name);
        return pos == -1 ? null : this.getRowId(pos);
    }

    public Temporal getTemporal(int pos) {
        throw new UnsupportedOperationException();
    }

    public OffsetTime getOffsetTime(int pos) {
        throw new UnsupportedOperationException();
    }

    public OffsetDateTime getOffsetDateTime(int pos) {
        throw new UnsupportedOperationException();
    }

    public LocalDateTime[] getArrayOfLocalDateTimes(int pos) {
        throw new UnsupportedOperationException();
    }

    public OffsetDateTime[] getArrayOfOffsetDateTimes(int pos) {
        throw new UnsupportedOperationException();
    }

    public Buffer[] getArrayOfBuffers(String column) {
        throw new UnsupportedOperationException();
    }

    public UUID[] getArrayOfUUIDs(String column) {
        throw new UnsupportedOperationException();
    }

    private Byte getByte(int pos) {
        Object val = this.getValue(pos);
        if (val instanceof Byte) {
            return (Byte)val;
        }
        if (val instanceof Number) {
            return ((Number)val).byteValue();
        }
        return null;
    }

    private Duration getDuration(int pos) {
        Object val = this.getValue(pos);
        if (val instanceof Duration) {
            return (Duration)val;
        }
        return null;
    }

    private Object getEnum(Class enumType, int position) {
        Object val = this.getValue(position);
        if (val instanceof String) {
            return Enum.valueOf(enumType, (String)val);
        }
        if (val instanceof Number) {
            T[] constants;
            int ordinal = ((Number)val).intValue();
            if (ordinal >= 0 && ordinal < (constants = enumType.getEnumConstants()).length) {
                return constants[ordinal];
            }
        } else if (val == null) {
            return null;
        }
        throw new ClassCastException();
    }
}

