/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.db2client.impl.codec;

import io.netty.buffer.ByteBuf;
import io.vertx.db2client.impl.codec.CommandCodec;
import io.vertx.db2client.impl.codec.DB2Encoder;
import io.vertx.db2client.impl.command.PingCommand;
import io.vertx.db2client.impl.drda.ConnectionMetaData;
import io.vertx.db2client.impl.drda.DRDAConnectRequest;
import io.vertx.db2client.impl.drda.DRDAConnectResponse;
import io.vertx.sqlclient.internal.command.CommandResponse;

class PingCommandCodec
extends CommandCodec<Void, PingCommand> {
    private final ConnectionMetaData md = new ConnectionMetaData();

    PingCommandCodec(PingCommand cmd) {
        super(cmd);
    }

    @Override
    void encode(DB2Encoder encoder) {
        super.encode(encoder);
        this.sendPingRequest();
    }

    @Override
    void decodePayload(ByteBuf payload, int payloadLength) {
        DRDAConnectResponse response = new DRDAConnectResponse(payload, this.md);
        response.readExchangeServerAttributes();
        this.completionHandler.handle((Object)CommandResponse.success(null));
    }

    private void sendPingRequest() {
        ByteBuf packet = this.allocateBuffer();
        int packetStartIdx = packet.writerIndex();
        DRDAConnectRequest cmd = new DRDAConnectRequest(packet, this.md);
        cmd.buildEXCSAT("db2jnt_application  JNT00001300", 10, 7, 12, 10, 0, 0, 0, 0, 0, 1208);
        cmd.completeCommand();
        int lenOfPayload = packet.writerIndex() - packetStartIdx;
        this.sendPacket(packet, lenOfPayload);
    }
}

