/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.docgen;

import com.sun.source.doctree.DocCommentTree;
import com.sun.source.doctree.DocTree;
import com.sun.source.doctree.EndElementTree;
import com.sun.source.doctree.EntityTree;
import com.sun.source.doctree.ErroneousTree;
import com.sun.source.doctree.LinkTree;
import com.sun.source.doctree.LiteralTree;
import com.sun.source.doctree.StartElementTree;
import com.sun.source.doctree.TextTree;
import com.sun.source.tree.BlockTree;
import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.tree.LineMap;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.StatementTree;
import com.sun.source.util.DocTreeScanner;
import com.sun.source.util.DocTrees;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.code.Symbol;
import io.vertx.docgen.Coordinate;
import io.vertx.docgen.DocException;
import io.vertx.docgen.DocGenException;
import io.vertx.docgen.DocWriter;
import io.vertx.docgen.Document;
import io.vertx.docgen.EntityUtils;
import io.vertx.docgen.Helper;
import io.vertx.docgen.LanguageFilterPostProcessor;
import io.vertx.docgen.PostProcessor;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;

public abstract class BaseProcessor
extends AbstractProcessor {
    protected DocTrees docTrees;
    protected Types typeUtils;
    protected Elements elementUtils;
    protected Helper helper;
    protected Set<PostProcessor> postProcessors = new LinkedHashSet<PostProcessor>();
    Map<String, String> failures = new HashMap<String, String>();
    private final LinkedList<PackageElement> stack = new LinkedList();

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.RELEASE_8;
    }

    @Override
    public Set<String> getSupportedOptions() {
        return new HashSet<String>(Arrays.asList("docgen.output", "docgen.extension"));
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return Collections.singleton(Document.class.getName());
    }

    public synchronized BaseProcessor registerPostProcessor(PostProcessor postProcessor) {
        if (this.getPostProcessor(postProcessor.getName()) != null) {
            throw new IllegalArgumentException("Post-processor with name '" + postProcessor.getName() + "' is already " + "registered.");
        }
        this.postProcessors.add(postProcessor);
        return this;
    }

    public synchronized PostProcessor getPostProcessor(String name) {
        for (PostProcessor pp : this.postProcessors) {
            if (!pp.getName().equalsIgnoreCase(name)) continue;
            return pp;
        }
        return null;
    }

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.docTrees = DocTrees.instance(processingEnv);
        this.typeUtils = processingEnv.getTypeUtils();
        this.elementUtils = processingEnv.getElementUtils();
        this.helper = new Helper(processingEnv);
        this.registerPostProcessor(new LanguageFilterPostProcessor());
    }

    private String render(List<? extends DocTree> trees) {
        final StringBuilder buffer = new StringBuilder();
        DocTreeScanner<Void, Void> visitor = new DocTreeScanner<Void, Void>(){

            @Override
            public Void visitText(TextTree node, Void aVoid) {
                buffer.append(node.getBody());
                return (Void)super.visitText(node, aVoid);
            }
        };
        trees.forEach(tree -> {
            Void cfr_ignored_0 = (Void)tree.accept(visitor, null);
        });
        return buffer.toString();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        if (this.failures.isEmpty()) {
            roundEnv.getElementsAnnotatedWith(Document.class).forEach(elt -> {
                PackageElement pkgElt = (PackageElement)elt;
                try {
                    this.handleGen(pkgElt);
                }
                catch (Exception e) {
                    Element reportedElt = e instanceof DocGenException ? ((DocGenException)e).getElement() : elt;
                    String msg = e.getMessage();
                    if (msg == null) {
                        msg = e.toString();
                    }
                    e.printStackTrace();
                    this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, msg, reportedElt);
                    if (reportedElt instanceof PackageElement) {
                        this.failures.put(((PackageElement)reportedElt).getQualifiedName().toString(), msg);
                    }
                    throw new UnsupportedOperationException("not implemented");
                }
            });
        }
        return false;
    }

    protected abstract void handleGen(PackageElement var1);

    protected String getExtension() {
        String extension = this.processingEnv.getOptions().get("docgen.extension");
        if (extension != null) {
            return extension;
        }
        return ".adoc";
    }

    protected String resolveLinkToPackageDoc(PackageElement elt) {
        Document annotation = elt.getAnnotation(Document.class);
        String fileName = annotation.fileName();
        if (fileName.isEmpty()) {
            return elt.toString() + this.getExtension();
        }
        return fileName;
    }

    private Coordinate resolveCoordinate(TypeElement typeElt) {
        try {
            URL manifestURL;
            InputStream manifestIs;
            JavaFileObject cf;
            URL classURL;
            Symbol.ClassSymbol cs = (Symbol.ClassSymbol)typeElt;
            if (cs.sourcefile != null && this.getURL(cs.sourcefile) != null) {
                return null;
            }
            if (cs.classfile != null && (classURL = this.getURL(cf = cs.classfile)) != null && classURL.getFile().endsWith(".class") && (manifestIs = (manifestURL = new URL(classURL.toString().substring(0, classURL.toString().length() - (typeElt.getQualifiedName().toString().length() + 6)) + "META-INF/MANIFEST.MF")).openStream()) != null) {
                Manifest manifest = new Manifest(manifestIs);
                Attributes attributes = manifest.getMainAttributes();
                String groupId = attributes.getValue(new Attributes.Name("Maven-Group-Id"));
                String artifactId = attributes.getValue(new Attributes.Name("Maven-Artifact-Id"));
                String version = attributes.getValue(new Attributes.Name("Maven-Version"));
                return new Coordinate(groupId, artifactId, version);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return new Coordinate(null, null, null);
    }

    private URL getURL(JavaFileObject fileObject) {
        try {
            return fileObject.toUri().toURL();
        }
        catch (Exception e) {
            return null;
        }
    }

    protected abstract String resolveTypeLink(TypeElement var1, Coordinate var2);

    protected abstract String resolveConstructorLink(ExecutableElement var1, Coordinate var2);

    protected abstract String resolveMethodLink(ExecutableElement var1, Coordinate var2);

    protected abstract String resolveFieldLink(VariableElement var1, Coordinate var2);

    protected abstract String renderSource(ExecutableElement var1, String var2);

    protected String resolveLabel(Element elt) {
        String label = elt.getSimpleName().toString();
        if (elt.getModifiers().contains((Object)Modifier.STATIC) && (elt.getKind() == ElementKind.METHOD || elt.getKind() == ElementKind.FIELD)) {
            label = elt.getEnclosingElement().getSimpleName() + "." + label;
        }
        return label;
    }

    protected abstract String getName();

    protected final void process(Writer buffer, final PackageElement pkgElt) {
        for (PackageElement stackElt : this.stack) {
            if (!pkgElt.getQualifiedName().equals(stackElt.getQualifiedName())) continue;
            throw new DocException(this.stack.peekLast(), "Circular include");
        }
        this.stack.addLast(pkgElt);
        final DocWriter writer = new DocWriter(buffer);
        final String pkgSource = this.helper.readSource(pkgElt);
        final TreePath pkgTree = this.docTrees.getPath(pkgElt);
        final DocCommentTree doc = this.docTrees.getDocCommentTree(pkgTree);
        DocTreeScanner<Void, Void> visitor = new DocTreeScanner<Void, Void>(){

            private void copyContent(DocTree node) {
                int from = (int)BaseProcessor.this.docTrees.getSourcePositions().getStartPosition(pkgTree.getCompilationUnit(), doc, node);
                int to = (int)BaseProcessor.this.docTrees.getSourcePositions().getEndPosition(pkgTree.getCompilationUnit(), doc, node);
                writer.append(pkgSource, from, to);
            }

            @Override
            public Void visitDocComment(DocCommentTree node, Void v) {
                v = (Void)this.scan(node.getFirstSentence(), v);
                List<? extends DocTree> body = node.getBody();
                if (body.size() > 0) {
                    writer.append("\n\n");
                    writer.resetParagraph();
                    v = (Void)this.scan(body, v);
                }
                return v;
            }

            @Override
            public Void visitErroneous(ErroneousTree node, Void v) {
                return this.visitText((TextTree)node, v);
            }

            @Override
            public Void visitText(TextTree node, Void v) {
                String body = node.getBody();
                Matcher matcher = Helper.LANG_PATTERN.matcher(body);
                int prev = 0;
                while (matcher.find()) {
                    writer.append(body, prev, matcher.start());
                    if (matcher.group(1) != null) {
                        writer.append("$lang");
                    } else {
                        writer.append(BaseProcessor.this.getName());
                    }
                    prev = matcher.end();
                }
                writer.append(body, prev, body.length());
                return (Void)super.visitText(node, v);
            }

            @Override
            public Void visitLiteral(LiteralTree node, Void aVoid) {
                writer.append("`").append(node.getBody().getBody()).append("`");
                return (Void)super.visitLiteral(node, aVoid);
            }

            @Override
            public Void visitEntity(EntityTree node, Void aVoid) {
                writer.append(EntityUtils.unescapeEntity(node.getName().toString()));
                return (Void)super.visitEntity(node, aVoid);
            }

            @Override
            public Void visitStartElement(StartElementTree node, Void v) {
                this.copyContent(node);
                return v;
            }

            @Override
            public Void visitEndElement(EndElementTree node, Void v) {
                writer.write("</");
                writer.append(node.getName());
                writer.append('>');
                return v;
            }

            @Override
            public Void visitLink(LinkTree node, Void v) {
                String signature = node.getReference().getSignature();
                Element resolvedElt = BaseProcessor.this.helper.resolveLink(signature);
                if (resolvedElt == null) {
                    throw new DocGenException(pkgElt, "Could not resolve " + signature);
                }
                if (resolvedElt instanceof PackageElement) {
                    PackageElement includedElt = (PackageElement)resolvedElt;
                    if (includedElt.getAnnotation(Document.class) == null) {
                        BaseProcessor.this.process(writer, includedElt);
                    } else {
                        String link = BaseProcessor.this.resolveLinkToPackageDoc((PackageElement)resolvedElt);
                        writer.append(link);
                    }
                } else {
                    String link;
                    if (BaseProcessor.this.helper.isExample(resolvedElt)) {
                        String source = BaseProcessor.this.helper.readSource(resolvedElt);
                        switch (resolvedElt.getKind()) {
                            case CONSTRUCTOR: 
                            case METHOD: {
                                String fragment = BaseProcessor.this.helper.hasToBeTranslated(resolvedElt) ? BaseProcessor.this.renderSource((ExecutableElement)resolvedElt, source) : BaseProcessor.this.defaultRenderSource((ExecutableElement)resolvedElt, source);
                                if (fragment != null) {
                                    writer.literalMode();
                                    writer.append(fragment);
                                    writer.commentMode();
                                }
                                return v;
                            }
                            case CLASS: {
                                if (BaseProcessor.this.helper.hasToBeTranslated(resolvedElt)) {
                                    throw new UnsupportedOperationException("File inclusion is only supported for not translated Java classes");
                                }
                                if (source != null) {
                                    writer.literalMode();
                                    writer.append(source);
                                    writer.commentMode();
                                }
                                return v;
                            }
                        }
                        throw new UnsupportedOperationException("unsupported element: " + (Object)((Object)resolvedElt.getKind()));
                    }
                    switch (resolvedElt.getKind()) {
                        case CLASS: 
                        case INTERFACE: 
                        case ENUM: {
                            TypeElement typeElt = (TypeElement)resolvedElt;
                            link = BaseProcessor.this.resolveTypeLink(typeElt, BaseProcessor.this.resolveCoordinate(typeElt));
                            break;
                        }
                        case METHOD: {
                            ExecutableElement methodElt = (ExecutableElement)resolvedElt;
                            TypeElement typeElt = (TypeElement)methodElt.getEnclosingElement();
                            link = BaseProcessor.this.resolveMethodLink(methodElt, BaseProcessor.this.resolveCoordinate(typeElt));
                            break;
                        }
                        case CONSTRUCTOR: {
                            ExecutableElement constructorElt = (ExecutableElement)resolvedElt;
                            TypeElement typeElt = (TypeElement)constructorElt.getEnclosingElement();
                            link = BaseProcessor.this.resolveConstructorLink(constructorElt, BaseProcessor.this.resolveCoordinate(typeElt));
                            break;
                        }
                        case FIELD: 
                        case ENUM_CONSTANT: {
                            VariableElement variableElt = (VariableElement)resolvedElt;
                            TypeElement typeElt = (TypeElement)variableElt.getEnclosingElement();
                            link = BaseProcessor.this.resolveFieldLink(variableElt, BaseProcessor.this.resolveCoordinate(typeElt));
                            break;
                        }
                        default: {
                            throw new UnsupportedOperationException("Not yet implemented " + resolvedElt + " with kind " + (Object)((Object)resolvedElt.getKind()));
                        }
                    }
                    String label = BaseProcessor.this.render(node.getLabel()).trim();
                    if (label.length() == 0) {
                        label = BaseProcessor.this.resolveLabel(resolvedElt);
                    }
                    if (link != null) {
                        writer.append("`link:").append(link).append("[").append(label).append("]`");
                    } else {
                        writer.append("`").append(label).append("`");
                    }
                }
                return v;
            }
        };
        doc.accept(visitor, null);
        this.stack.removeLast();
    }

    protected void write(PackageElement docElt, String content) {
        String processed = this.applyVariableSubstitution(content);
        processed = this.applyPostProcessors(processed);
        String outputOpt = this.processingEnv.getOptions().get("docgen.output");
        if (outputOpt != null) {
            outputOpt = outputOpt.replace("$lang", this.getName());
            try {
                Document doc = docElt.getAnnotation(Document.class);
                String relativeName = doc.fileName();
                if (relativeName.isEmpty()) {
                    relativeName = docElt.getQualifiedName() + this.getExtension();
                }
                File dir = new File(outputOpt);
                int i = relativeName.indexOf(47);
                while (i != -1) {
                    dir = new File(dir, relativeName.substring(0, i));
                    relativeName = relativeName.substring(i + 1);
                    i = relativeName.indexOf(47, i + 1);
                }
                this.ensureDir(docElt, dir);
                File file = new File(dir, relativeName);
                try (FileWriter writer = new FileWriter(file);){
                    writer.write(processed);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    protected String applyPostProcessors(String content) {
        List<String> lines = Arrays.asList(content.split("\r?\n"));
        StringBuilder processed = new StringBuilder();
        Iterator<String> iterator = lines.iterator();
        while (iterator.hasNext()) {
            String line = iterator.next();
            String trimmedLine = line.trim();
            if (!PostProcessor.isBlockDeclaration(trimmedLine)) {
                processed.append(line);
                if (!iterator.hasNext()) continue;
                processed.append("\n");
                continue;
            }
            String name = PostProcessor.getProcessorName(trimmedLine);
            String[] attributes = PostProcessor.getProcessorAttributes(trimmedLine);
            PostProcessor postProcessor = this.getPostProcessor(name);
            if (postProcessor == null) {
                processed.append(line);
                if (!iterator.hasNext()) continue;
                processed.append("\n");
                continue;
            }
            String block = PostProcessor.getBlockContent(iterator);
            processed.append(postProcessor.process(this, block, attributes));
            if (!iterator.hasNext()) continue;
            processed.append("\n");
        }
        return processed.toString();
    }

    protected final String defaultRenderSource(ExecutableElement elt, String source) {
        TreePath resolvedTP = this.docTrees.getPath(elt);
        CompilationUnitTree unit = resolvedTP.getCompilationUnit();
        MethodTree methodTree = (MethodTree)resolvedTP.getLeaf();
        BlockTree blockTree = methodTree.getBody();
        List<? extends StatementTree> statements = blockTree.getStatements();
        if (statements.size() > 0) {
            int from;
            int to = (int)this.docTrees.getSourcePositions().getEndPosition(unit, statements.get(statements.size() - 1));
            for (from = (int)this.docTrees.getSourcePositions().getStartPosition(unit, statements.get(0)); from > 1 && source.charAt(from - 1) != '\n'; --from) {
            }
            while (to < source.length() && source.charAt(to) != '\n') {
                ++to;
            }
            String block = source.substring(from, to);
            int blockMargin = Integer.MAX_VALUE;
            LineMap lineMap = unit.getLineMap();
            for (StatementTree statementTree : statements) {
                int statementStart;
                int lineStart = statementStart = (int)this.docTrees.getSourcePositions().getStartPosition(unit, statementTree);
                while (lineMap.getLineNumber(statementStart) == lineMap.getLineNumber(lineStart - 1)) {
                    --lineStart;
                }
                blockMargin = Math.min(blockMargin, statementStart - lineStart);
            }
            StringBuilder fragment = new StringBuilder();
            Scanner scanner = new Scanner(block).useDelimiter("\n");
            while (scanner.hasNext()) {
                String line = (String)scanner.next();
                int margin = Math.min(blockMargin, line.length());
                line = line.substring(margin);
                fragment.append(line);
                if (!scanner.hasNext()) continue;
                fragment.append('\n');
            }
            return fragment.toString();
        }
        return null;
    }

    private void ensureDir(PackageElement elt, File dir) {
        if (dir.exists()) {
            if (!dir.isDirectory()) {
                throw new DocGenException(elt, "File " + dir.getAbsolutePath() + " is not a dir");
            }
        } else if (!dir.mkdirs()) {
            throw new DocGenException(elt, "could not create dir " + dir.getAbsolutePath());
        }
    }

    public String applyVariableSubstitution(String content) {
        for (Map.Entry<String, String> entry : this.processingEnv.getOptions().entrySet()) {
            content = content.replace("${" + entry.getKey() + "}", entry.getValue());
        }
        return content;
    }
}

