/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.docgen;

import com.sun.source.tree.CompilationUnitTree;
import com.sun.source.util.DocTrees;
import io.vertx.docgen.DocGenException;
import io.vertx.docgen.Source;
import java.io.IOException;
import java.io.Reader;
import java.util.Arrays;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.QualifiedNameable;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.lang.model.util.Types;

class Helper {
    static final Pattern LANG_PATTERN = Pattern.compile("(\\\\)?\\$lang");
    final Types typeUtils;
    final Elements elementUtils;
    final DocTrees docTrees;
    private static final Pattern P = Pattern.compile("#(\\p{javaJavaIdentifierStart}(?:\\p{javaJavaIdentifierPart})*)(?:\\((.*)\\))?$");

    public Helper(ProcessingEnvironment env) {
        this.typeUtils = env.getTypeUtils();
        this.elementUtils = env.getElementUtils();
        this.docTrees = DocTrees.instance(env);
    }

    boolean matchesConstructor(Element elt, String memberName, Predicate<ExecutableElement> parametersMatcher) {
        if (elt.getKind() == ElementKind.CONSTRUCTOR) {
            ExecutableElement constructorElt = (ExecutableElement)elt;
            TypeElement typeElt = (TypeElement)constructorElt.getEnclosingElement();
            return typeElt.getSimpleName().toString().equals(memberName) && parametersMatcher.test(constructorElt);
        }
        return false;
    }

    boolean matchesMethod(Element elt, String memberName, Predicate<ExecutableElement> parametersMatcher) {
        if (elt.getKind() == ElementKind.METHOD) {
            ExecutableElement methodElt = (ExecutableElement)elt;
            return methodElt.getSimpleName().toString().equals(memberName) && parametersMatcher.test(methodElt);
        }
        return false;
    }

    boolean matchesFieldOrEnumConstant(Element elt, String memberName) {
        ElementKind kind = elt.getKind();
        return (kind == ElementKind.FIELD || kind == ElementKind.ENUM_CONSTANT) && elt.getSimpleName().toString().equals(memberName);
    }

    public Element resolveLink(String signature) {
        Matcher signatureMatcher = P.matcher(signature);
        if (signatureMatcher.find()) {
            Predicate<Element> memberMatcher;
            String memberName = signatureMatcher.group(1);
            String typeName = signature.substring(0, signatureMatcher.start());
            TypeElement typeElt = this.elementUtils.getTypeElement(typeName);
            if (typeElt == null) {
                return null;
            }
            if (signatureMatcher.group(2) != null) {
                String t = signatureMatcher.group(2).trim();
                Predicate<ExecutableElement> parametersMatcher = t.length() == 0 ? exeElt -> exeElt.getParameters().isEmpty() : this.parametersMatcher(t.split("\\s*,\\s*"));
                memberMatcher = elt -> this.matchesConstructor((Element)elt, memberName, parametersMatcher) || this.matchesMethod((Element)elt, memberName, parametersMatcher);
            } else {
                memberMatcher = elt -> this.matchesConstructor((Element)elt, memberName, exeElt -> true) || this.matchesMethod((Element)elt, memberName, exeElt -> true) || this.matchesFieldOrEnumConstant((Element)elt, memberName);
            }
            for (ElementKind kind : Arrays.asList(ElementKind.FIELD, ElementKind.ENUM_CONSTANT, ElementKind.CONSTRUCTOR, ElementKind.METHOD)) {
                for (Element element : this.elementUtils.getAllMembers(typeElt)) {
                    if (element.getKind() != kind || !memberMatcher.test(element)) continue;
                    return element;
                }
            }
            return null;
        }
        QualifiedNameable elt2 = this.elementUtils.getTypeElement(signature);
        if (elt2 == null) {
            elt2 = this.elementUtils.getPackageElement(signature);
        }
        return elt2;
    }

    Predicate<ExecutableElement> parametersMatcher(String[] parameterSignature) {
        return exeElt -> {
            if (exeElt.getParameters().size() == parameterSignature.length) {
                TypeMirror tm2 = exeElt.asType();
                ExecutableType tm3 = (ExecutableType)this.typeUtils.erasure(tm2);
                for (int j = 0; j < parameterSignature.length; ++j) {
                    String t1 = tm3.getParameterTypes().get(j).toString();
                    String t2 = parameterSignature[j];
                    if (t2.indexOf(46) == -1) {
                        t1 = t1.substring(t1.lastIndexOf(46) + 1);
                    }
                    if (t1.equals(t2)) continue;
                    return false;
                }
                return true;
            }
            return false;
        };
    }

    boolean isExample(Element elt) {
        return elt.getAnnotation(Source.class) != null || elt.getEnclosingElement() != null && this.isExample(elt.getEnclosingElement());
    }

    boolean hasToBeTranslated(Element elt) {
        Element current = elt;
        Source source = current.getAnnotation(Source.class);
        while (source == null) {
            current = current.getEnclosingElement();
            source = current.getAnnotation(Source.class);
        }
        return source.translate();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    String readSource(Element elt) {
        CompilationUnitTree unit = this.docTrees.getPath(elt).getCompilationUnit();
        StringBuilder source = new StringBuilder();
        try (Reader reader = unit.getSourceFile().openReader(true);){
            char[] buffer = new char[256];
            while (true) {
                int len;
                if ((len = reader.read(buffer)) == -1) {
                    String string = source.toString();
                    return string;
                }
                source.append(buffer, 0, len);
            }
        }
        catch (IOException e) {
            throw new DocGenException(elt, "Could not read source code of element " + elt);
        }
    }
}

