/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.docgen;

import io.vertx.docgen.BaseProcessor;
import java.util.Arrays;
import java.util.Iterator;
import java.util.regex.Pattern;

public interface PostProcessor {
    public static final String EMPTY_CONTENT = "";
    public static final Pattern BLOCK_DECLARATION = Pattern.compile("\\[.+\\]");

    public String getName();

    public String process(BaseProcessor var1, String var2, String ... var3);

    public static boolean isBlockDeclaration(String line) {
        return BLOCK_DECLARATION.matcher(line).matches();
    }

    public static String getProcessorName(String line) {
        int indexOfComma = line.indexOf(",");
        return line.substring(1, indexOfComma != -1 ? indexOfComma : line.length() - 1).trim();
    }

    public static String[] getProcessorAttributes(String line) {
        int indexOfComma = line.indexOf(",");
        if (indexOfComma == -1) {
            return new String[0];
        }
        return (String[])Arrays.stream(line.substring(indexOfComma + 1, line.length() - 1).split(",")).map(String::trim).toArray(String[]::new);
    }

    public static String getBlockContent(Iterator<String> iterator) {
        StringBuilder content = new StringBuilder();
        boolean startOfBlock = false;
        boolean endOfBlock = false;
        while (iterator.hasNext() && !endOfBlock) {
            String line = iterator.next().trim();
            if (line.equals("----") && !startOfBlock) {
                startOfBlock = true;
                continue;
            }
            if (line.equals("\\----") && startOfBlock) {
                content.append("----").append("\n");
                continue;
            }
            if (line.equals("----") && startOfBlock) {
                endOfBlock = true;
                continue;
            }
            if (!line.equals("----") && !startOfBlock) {
                return line;
            }
            content.append(line).append("\n");
        }
        return content.toString();
    }
}

