/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.docgen;

import java.io.IOException;
import java.io.Writer;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;

class DocWriter
extends Writer {
    private final StringBuilder delegate;
    private final List<Object> chunks = new ArrayList<Object>();
    private int status = 0;
    private boolean literal = false;

    DocWriter() {
        this.delegate = new StringBuilder();
    }

    String render() {
        StringBuilder buffer = new StringBuilder();
        this.render(buffer);
        return buffer.toString();
    }

    private void render(StringBuilder buffer) {
        this.chunks.forEach(chunk -> {
            if (chunk instanceof Supplier) {
                Supplier consumer = (Supplier)chunk;
                DocWriter writer = (DocWriter)consumer.get();
                writer.render(buffer);
            } else {
                buffer.append(chunk);
            }
        });
        buffer.append((CharSequence)this.delegate);
        this.delegate.setLength(0);
        this.chunks.clear();
    }

    void exec(Runnable r) {
        int st = this.status;
        boolean bl = this.literal;
        this.status = 0;
        this.literal = false;
        r.run();
        this.status = st;
        this.literal = bl;
    }

    void resetParagraph() {
        this.status = 0;
        this.literal = false;
    }

    void literalMode() {
        this.literal = true;
    }

    void commentMode() {
        this.literal = false;
    }

    void write(Supplier<DocWriter> future) {
        if (this.delegate.length() > 0) {
            String s = this.delegate.toString();
            this.delegate.setLength(0);
            this.chunks.add(s);
        }
        this.chunks.add(future);
    }

    @Override
    public void write(int c) {
        try {
            super.write(c);
        }
        catch (IOException e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    @Override
    public void write(char[] cbuf) {
        try {
            super.write(cbuf);
        }
        catch (IOException e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    @Override
    public void write(String str) {
        try {
            super.write(str);
        }
        catch (IOException e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    @Override
    public void write(String str, int off, int len) {
        try {
            super.write(str, off, len);
        }
        catch (IOException e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    @Override
    public DocWriter append(CharSequence csq) {
        try {
            return (DocWriter)super.append(csq);
        }
        catch (IOException e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    @Override
    public DocWriter append(CharSequence csq, int start, int end) {
        try {
            return (DocWriter)super.append(csq, start, end);
        }
        catch (IOException e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    @Override
    public DocWriter append(char c) {
        try {
            return (DocWriter)super.append(c);
        }
        catch (IOException e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    @Override
    public void write(char[] cbuf, int off, int len) {
        if (this.literal) {
            while (off < len) {
                this.delegate.append(cbuf[off++]);
            }
        } else {
            block5: while (off < len) {
                char c = cbuf[off++];
                switch (c) {
                    case '\n': {
                        this.status = 1;
                        this.delegate.append(c);
                        continue block5;
                    }
                    case ' ': {
                        if (this.status == 1) {
                            this.status = 2;
                            continue block5;
                        }
                        this.delegate.append(c);
                        continue block5;
                    }
                }
                this.delegate.append(c);
                if (this.status != 1) continue;
                this.status = 2;
            }
        }
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
    }
}

