/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.dropwizard;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.metrics.MetricsOptions;
import io.vertx.ext.dropwizard.Match;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

@DataObject
public class DropwizardMetricsOptions
extends MetricsOptions {
    public static final boolean DEFAULT_JMX_ENABLED = false;
    public static final List<Match> DEFAULT_MONITORED_HANDLERS = Collections.emptyList();
    public static final List<Match> DEFAULT_MONITORED_HTTP_SERVER_URIS = Collections.emptyList();
    public static final List<Match> DEFAULT_MONITORED_HTTP_CLIENT_URIS = Collections.emptyList();
    private String registryName;
    private boolean jmxEnabled;
    private String jmxDomain;
    private List<Match> monitoredEventBusHandlers;
    private List<Match> monitoredHttpServerUris;
    private List<Match> monitoredHttpClientUris;

    public DropwizardMetricsOptions() {
        this.jmxEnabled = false;
        this.monitoredEventBusHandlers = new ArrayList<Match>(DEFAULT_MONITORED_HANDLERS);
        this.monitoredHttpServerUris = new ArrayList<Match>(DEFAULT_MONITORED_HTTP_SERVER_URIS);
        this.monitoredHttpClientUris = new ArrayList<Match>(DEFAULT_MONITORED_HTTP_CLIENT_URIS);
    }

    public DropwizardMetricsOptions(DropwizardMetricsOptions other) {
        super((MetricsOptions)other);
        this.registryName = other.getRegistryName();
        this.jmxEnabled = other.isJmxEnabled();
        this.jmxDomain = other.getJmxDomain();
        this.monitoredEventBusHandlers = new ArrayList<Match>(other.monitoredEventBusHandlers);
    }

    public DropwizardMetricsOptions(JsonObject json) {
        super(json);
        this.registryName = json.getString("registryName");
        this.jmxEnabled = json.getBoolean("jmxEnabled", Boolean.valueOf(false));
        this.jmxDomain = json.getString("jmxDomain");
        this.monitoredEventBusHandlers = new ArrayList<Match>();
        JsonArray handlerAddressesArray = json.getJsonArray("monitoredHandlers");
        if (handlerAddressesArray != null) {
            for (Object o : handlerAddressesArray) {
                this.monitoredEventBusHandlers.add(new Match((JsonObject)o));
            }
        }
    }

    public String getRegistryName() {
        return this.registryName;
    }

    public DropwizardMetricsOptions setRegistryName(String registryName) {
        this.registryName = registryName;
        return this;
    }

    public boolean isJmxEnabled() {
        return this.jmxEnabled;
    }

    public DropwizardMetricsOptions setJmxEnabled(boolean jmxEnabled) {
        this.jmxEnabled = jmxEnabled;
        if (jmxEnabled) {
            this.setEnabled(true);
        }
        return this;
    }

    public String getJmxDomain() {
        return this.jmxDomain;
    }

    public DropwizardMetricsOptions setJmxDomain(String jmxDomain) {
        this.jmxDomain = jmxDomain;
        return this;
    }

    public List<Match> getMonitoredEventBusHandlers() {
        return this.monitoredEventBusHandlers;
    }

    public DropwizardMetricsOptions addMonitoredEventBusHandler(Match match) {
        this.monitoredEventBusHandlers.add(match);
        return this;
    }

    public List<Match> getMonitoredHttpServerUris() {
        return this.monitoredHttpServerUris;
    }

    public DropwizardMetricsOptions addMonitoredHttpServerUri(Match match) {
        this.monitoredHttpServerUris.add(match);
        return this;
    }

    public List<Match> getMonitoredHttpClientUris() {
        return this.monitoredHttpClientUris;
    }

    public DropwizardMetricsOptions setEnabled(boolean enable) {
        return (DropwizardMetricsOptions)super.setEnabled(enable);
    }

    public DropwizardMetricsOptions addMonitoredHttpClientUri(Match match) {
        this.monitoredHttpClientUris.add(match);
        return this;
    }
}

