/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.dropwizard.impl;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Gauge;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.Meter;
import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import io.vertx.core.json.JsonObject;
import io.vertx.core.metrics.Measured;
import io.vertx.core.spi.metrics.Metrics;
import io.vertx.core.spi.metrics.MetricsProvider;
import io.vertx.ext.dropwizard.ThroughputMeter;
import io.vertx.ext.dropwizard.ThroughputTimer;
import io.vertx.ext.dropwizard.impl.Helper;
import io.vertx.ext.dropwizard.impl.Registry;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;

public abstract class AbstractMetrics
implements Metrics {
    protected final Registry registry;
    protected final String baseName;

    public static AbstractMetrics unwrap(Measured measured) {
        MetricsProvider provider = (MetricsProvider)measured;
        Metrics baseMetrics = provider.getMetrics();
        if (baseMetrics instanceof AbstractMetrics) {
            return (AbstractMetrics)baseMetrics;
        }
        return null;
    }

    AbstractMetrics(Registry registry, String baseName) {
        this.registry = registry;
        this.baseName = baseName;
    }

    public JsonObject metrics() {
        String baseName = this.baseName();
        Map<String, Object> map = this.registry.getMetrics().entrySet().stream().filter(e -> ((String)e.getKey()).startsWith(baseName)).collect(Collectors.toMap(e -> this.projectName((String)e.getKey()), e -> Helper.convertMetric((Metric)e.getValue(), TimeUnit.SECONDS, TimeUnit.MILLISECONDS)));
        return new JsonObject(map);
    }

    String projectName(String name) {
        String baseName = this.baseName();
        return name.substring(baseName.length() + 1);
    }

    protected Registry registry() {
        return this.registry;
    }

    public String baseName() {
        return this.baseName;
    }

    protected String nameOf(String ... names) {
        return MetricRegistry.name((String)this.baseName, (String[])names);
    }

    protected static String instanceName(String baseName, Object instance) {
        return MetricRegistry.name((String)baseName, (String[])new String[]{"@" + Integer.toHexString(instance.hashCode())});
    }

    public boolean isEnabled() {
        return true;
    }

    protected <T> Gauge<T> gauge(Gauge<T> gauge, String ... names) {
        return (Gauge)this.registry.register(this.nameOf(names), (Metric)gauge);
    }

    protected Counter counter(String ... names) {
        return this.registry.counter(this.nameOf(names));
    }

    protected Histogram histogram(String ... names) {
        return this.registry.histogram(this.nameOf(names));
    }

    protected Meter meter(String ... names) {
        return this.registry.meter(this.nameOf(names));
    }

    protected Timer timer(String ... names) {
        return this.registry.timer(this.nameOf(names));
    }

    protected ThroughputMeter throughputMeter(String ... names) {
        return this.registry.throughputMeter(this.nameOf(names));
    }

    protected ThroughputTimer throughputTimer(String ... names) {
        return this.registry.throughputTimer(this.nameOf(names));
    }

    protected void remove(String ... names) {
        this.registry.remove(this.nameOf(names));
    }

    protected void removeAll() {
        this.registry.removeMatching((name, metric) -> name.startsWith(this.baseName));
    }
}

