/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.dropwizard.impl;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.SharedMetricRegistries;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.metrics.MetricsOptions;
import io.vertx.core.spi.VertxMetricsFactory;
import io.vertx.core.spi.metrics.VertxMetrics;
import io.vertx.ext.dropwizard.DropwizardMetricsOptions;
import io.vertx.ext.dropwizard.impl.Registry;
import io.vertx.ext.dropwizard.impl.VertxMetricsImpl;
import io.vertx.ext.dropwizard.reporters.JmxReporter;

public class VertxMetricsFactoryImpl
implements VertxMetricsFactory {
    public VertxMetrics metrics(Vertx vertx, VertxOptions options) {
        MetricRegistry other;
        MetricsOptions baseOptions = options.getMetricsOptions();
        DropwizardMetricsOptions metricsOptions = baseOptions instanceof DropwizardMetricsOptions ? (DropwizardMetricsOptions)baseOptions : new DropwizardMetricsOptions(baseOptions.toJson());
        Registry registry = new Registry();
        if (metricsOptions.getRegistryName() != null && (other = SharedMetricRegistries.add((String)metricsOptions.getRegistryName(), (MetricRegistry)registry)) != null && other instanceof Registry) {
            registry = (Registry)other;
        }
        VertxMetricsImpl metrics = new VertxMetricsImpl(registry, options, metricsOptions);
        if (metricsOptions.isJmxEnabled()) {
            String jmxDomain = metricsOptions.getJmxDomain();
            if (jmxDomain == null) {
                jmxDomain = "vertx@" + Integer.toHexString(vertx.hashCode());
            }
            JmxReporter reporter = JmxReporter.forRegistry(metrics.registry()).inDomain(jmxDomain).build();
            metrics.setDoneHandler((Handler<Void>)((Handler)v -> reporter.stop()));
            reporter.start();
        }
        return metrics;
    }
}

