/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.dropwizard.impl;

import com.codahale.metrics.Metric;
import com.codahale.metrics.MetricRegistry;
import io.vertx.ext.dropwizard.ThroughputMeter;
import io.vertx.ext.dropwizard.ThroughputTimer;
import java.util.function.Function;

public class Registry
extends MetricRegistry {
    private static final Function<Metric, ThroughputMeter> THROUGHPUT_METER = metric -> {
        if (metric != null) {
            return (ThroughputMeter)((Object)metric);
        }
        return new ThroughputMeter();
    };
    private static final Function<Metric, ThroughputTimer> THROUGHPUT_TIMER = metric -> {
        if (metric != null) {
            return (ThroughputTimer)((Object)metric);
        }
        return new ThroughputTimer();
    };

    public void shutdown() {
        this.removeMatching((name, metric) -> true);
    }

    public ThroughputMeter throughputMeter(String name) {
        return this.getOrAdd(name, THROUGHPUT_METER);
    }

    public ThroughputTimer throughputTimer(String name) {
        return this.getOrAdd(name, THROUGHPUT_TIMER);
    }

    public <M extends Metric> M getOrAdd(String name, Function<Metric, M> metricProvider) {
        block4: {
            Metric found;
            Metric metric = (Metric)this.getMetrics().get(name);
            Metric metric2 = found = metric != null ? (Metric)metricProvider.apply(metric) : null;
            if (found != null) {
                return (M)found;
            }
            if (metric == null) {
                try {
                    return (M)this.register(name, (Metric)metricProvider.apply(null));
                }
                catch (IllegalArgumentException e) {
                    metric = (Metric)this.getMetrics().get(name);
                    found = (Metric)metricProvider.apply(metric);
                    if (found == null) break block4;
                    return (M)found;
                }
            }
        }
        throw new IllegalArgumentException(name + " is already used for a different type of metric");
    }
}

