/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.dropwizard.impl;

import com.codahale.metrics.Timer;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpServerResponse;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.spi.metrics.HttpServerMetrics;
import io.vertx.ext.dropwizard.Match;
import io.vertx.ext.dropwizard.impl.AbstractMetrics;
import io.vertx.ext.dropwizard.impl.HttpMetricsImpl;
import io.vertx.ext.dropwizard.impl.RequestMetric;
import io.vertx.ext.dropwizard.impl.WebSocketMetric;
import java.util.List;

class HttpServerMetricsImpl
extends HttpMetricsImpl
implements HttpServerMetrics<RequestMetric, WebSocketMetric, Timer.Context> {
    HttpServerMetricsImpl(AbstractMetrics metrics, String baseName, List<Match> monitoredUris, SocketAddress localAddress) {
        super(metrics, baseName, localAddress, monitoredUris);
    }

    public RequestMetric requestBegin(Timer.Context socketMetric, HttpServerRequest request) {
        return this.createRequestMetric(request.method(), request.uri());
    }

    public void responseEnd(RequestMetric requestMetric, HttpServerResponse response) {
        this.end(requestMetric, response.getStatusCode());
    }

    public WebSocketMetric connected(Timer.Context socketMetric, ServerWebSocket serverWebSocket) {
        return this.createWebSocketMetric();
    }

    public void disconnected(WebSocketMetric serverWebSocketMetric) {
        this.disconnect(serverWebSocketMetric);
    }
}

