/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.dropwizard.impl;

import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.SharedMetricRegistries;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.impl.FileResolver;
import io.vertx.core.json.DecodeException;
import io.vertx.core.json.JsonObject;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.impl.LoggerFactory;
import io.vertx.core.metrics.MetricsOptions;
import io.vertx.core.spi.VertxMetricsFactory;
import io.vertx.core.spi.metrics.VertxMetrics;
import io.vertx.ext.dropwizard.DropwizardMetricsOptions;
import io.vertx.ext.dropwizard.impl.VertxMetricsImpl;
import io.vertx.ext.dropwizard.reporters.JmxReporter;
import java.io.File;
import java.io.IOException;
import java.util.Scanner;

public class VertxMetricsFactoryImpl
implements VertxMetricsFactory {
    private Logger logger = LoggerFactory.getLogger(VertxMetricsFactoryImpl.class);

    public VertxMetrics metrics(Vertx vertx, VertxOptions options) {
        MetricRegistry other;
        DropwizardMetricsOptions metricsOptions;
        MetricsOptions baseOptions = options.getMetricsOptions();
        if (baseOptions instanceof DropwizardMetricsOptions) {
            JsonObject loadedFromFile;
            metricsOptions = (DropwizardMetricsOptions)baseOptions;
            if (metricsOptions.getConfigFileName() != null && !metricsOptions.getConfigFileName().isEmpty() && !(loadedFromFile = this.loadOptionsFile(metricsOptions.getConfigFileName(), new FileResolver(vertx))).isEmpty()) {
                metricsOptions = new DropwizardMetricsOptions(loadedFromFile);
            }
        } else {
            metricsOptions = new DropwizardMetricsOptions(baseOptions);
        }
        MetricRegistry registry = new MetricRegistry();
        boolean shutdown = true;
        if (metricsOptions.getRegistryName() != null && (other = SharedMetricRegistries.add((String)metricsOptions.getRegistryName(), (MetricRegistry)registry)) != null) {
            registry = other;
            shutdown = false;
        }
        VertxMetricsImpl metrics = new VertxMetricsImpl(registry, shutdown, options, metricsOptions);
        if (metricsOptions.isJmxEnabled()) {
            String jmxDomain = metricsOptions.getJmxDomain();
            if (jmxDomain == null) {
                jmxDomain = "vertx@" + Integer.toHexString(vertx.hashCode());
            }
            JmxReporter reporter = JmxReporter.forRegistry(metrics.registry()).inDomain(jmxDomain).build();
            metrics.setDoneHandler((Handler<Void>)((Handler)v -> reporter.stop()));
            reporter.start();
        }
        return metrics;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private JsonObject loadOptionsFile(String optionsFileName, FileResolver fileResolver) {
        File file = fileResolver.resolveFile(optionsFileName);
        try (Scanner scanner = new Scanner(file);){
            scanner.useDelimiter("\\A");
            String metricsConfigString = scanner.next();
            JsonObject jsonObject = new JsonObject(metricsConfigString);
            return jsonObject;
        }
        catch (IOException ioe) {
            this.logger.error((Object)"Error while reading metrics config file", (Throwable)ioe);
            return new JsonObject();
        }
        catch (DecodeException de) {
            this.logger.error((Object)"Error while decoding metrics config file into JSON", (Throwable)de);
        }
        return new JsonObject();
    }

    public MetricsOptions newOptions() {
        return new DropwizardMetricsOptions();
    }
}

