/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.dropwizard.impl;

import com.codahale.metrics.Counter;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.net.SocketAddress;
import io.vertx.ext.dropwizard.Match;
import io.vertx.ext.dropwizard.ThroughputMeter;
import io.vertx.ext.dropwizard.ThroughputTimer;
import io.vertx.ext.dropwizard.impl.AbstractMetrics;
import io.vertx.ext.dropwizard.impl.Matcher;
import io.vertx.ext.dropwizard.impl.NetServerMetricsImpl;
import io.vertx.ext.dropwizard.impl.RequestMetric;
import io.vertx.ext.dropwizard.impl.WebSocketMetric;
import java.util.EnumMap;
import java.util.List;
import java.util.concurrent.TimeUnit;

abstract class HttpMetricsImpl
extends NetServerMetricsImpl {
    private ThroughputTimer requests;
    private ThroughputMeter[] responses;
    private final Counter openWebSockets = this.counter("open-websockets");
    private Matcher uriMatcher;
    private EnumMap<HttpMethod, ThroughputTimer> methodRequests;

    public HttpMetricsImpl(AbstractMetrics metrics, String baseName, SocketAddress localAdress, List<Match> monitoredUris) {
        super(metrics, baseName, localAdress);
        this.uriMatcher = new Matcher(monitoredUris);
        this.requests = this.throughputTimer("requests");
        this.responses = new ThroughputMeter[]{this.throughputMeter("responses-1xx"), this.throughputMeter("responses-2xx"), this.throughputMeter("responses-3xx"), this.throughputMeter("responses-4xx"), this.throughputMeter("responses-5xx")};
        this.methodRequests = new EnumMap(HttpMethod.class);
        for (HttpMethod method : HttpMethod.values()) {
            this.methodRequests.put(method, this.throughputTimer(method.toString().toLowerCase() + "-requests"));
        }
    }

    protected RequestMetric createRequestMetric(HttpMethod method, String uri) {
        return new RequestMetric(method, uri);
    }

    protected WebSocketMetric createWebSocketMetric() {
        this.openWebSockets.inc();
        return null;
    }

    protected void end(RequestMetric metric, int statusCode) {
        if (this.closed) {
            return;
        }
        long duration = System.nanoTime() - metric.start;
        int responseStatus = statusCode / 100;
        if (responseStatus >= 1 && responseStatus <= 5) {
            this.responses[responseStatus - 1].mark();
        }
        this.requests.update(duration, TimeUnit.NANOSECONDS);
        if (metric.method != null) {
            this.methodRequests.get(metric.method).update(duration, TimeUnit.NANOSECONDS);
            if (metric.uri != null && this.uriMatcher.match(metric.uri)) {
                this.throughputTimer(metric.method.toString().toLowerCase() + "-requests", metric.uri).update(duration, TimeUnit.NANOSECONDS);
            }
        } else if (metric.uri != null && this.uriMatcher.match(metric.uri)) {
            this.throughputTimer("requests", metric.uri).update(duration, TimeUnit.NANOSECONDS);
        }
    }

    protected void disconnect(WebSocketMetric metric) {
        if (this.closed) {
            return;
        }
        this.openWebSockets.dec();
    }
}

