/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.dropwizard.impl;

import com.codahale.metrics.RatioGauge;
import com.codahale.metrics.Timer;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpClientRequest;
import io.vertx.core.http.HttpClientResponse;
import io.vertx.core.http.WebSocket;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.spi.metrics.HttpClientMetrics;
import io.vertx.ext.dropwizard.Match;
import io.vertx.ext.dropwizard.impl.AbstractMetrics;
import io.vertx.ext.dropwizard.impl.HttpMetricsImpl;
import io.vertx.ext.dropwizard.impl.RequestMetric;
import io.vertx.ext.dropwizard.impl.WebSocketMetric;
import java.util.List;

class HttpClientMetricsImpl
extends HttpMetricsImpl
implements HttpClientMetrics<RequestMetric, WebSocketMetric, Timer.Context> {
    HttpClientMetricsImpl(AbstractMetrics metrics, String baseName, HttpClientOptions options, List<Match> monitoredUris) {
        super(metrics, baseName, null, monitoredUris);
        final int maxPoolSize = options.getMaxPoolSize();
        this.gauge(() -> maxPoolSize, "connections", "max-pool-size");
        RatioGauge gauge = new RatioGauge(){

            protected RatioGauge.Ratio getRatio() {
                return RatioGauge.Ratio.of((double)HttpClientMetricsImpl.this.connections(), (double)maxPoolSize);
            }
        };
        this.gauge(gauge, new String[]{"connections", "pool-ratio"});
    }

    public RequestMetric requestBegin(Timer.Context socketMetric, SocketAddress localAddress, SocketAddress remoteAddress, HttpClientRequest request) {
        return this.createRequestMetric(request.method(), request.uri());
    }

    public void responseEnd(RequestMetric metric, HttpClientResponse response) {
        this.end(metric, response.statusCode());
    }

    public WebSocketMetric connected(Timer.Context socketMetric, WebSocket webSocket) {
        return this.createWebSocketMetric();
    }

    public void disconnected(WebSocketMetric webSocketMetric) {
        this.disconnect(webSocketMetric);
    }
}

