/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.dropwizard.impl;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Histogram;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.spi.metrics.TCPMetrics;
import io.vertx.ext.dropwizard.impl.AbstractMetrics;

class NetServerMetricsImpl
extends AbstractMetrics
implements TCPMetrics<Timer.Context> {
    private Counter openConnections = this.counter("open-netsockets");
    private Timer connections = this.timer("connections");
    private Histogram bytesRead;
    private Histogram bytesWritten;
    private Counter exceptions = this.counter("exceptions");
    protected volatile boolean closed;

    NetServerMetricsImpl(AbstractMetrics metrics, String baseName, SocketAddress localAddress) {
        super(metrics.registry(), localAddress != null ? MetricRegistry.name((String)baseName, (String[])new String[]{NetServerMetricsImpl.addressName(localAddress)}) : baseName);
        this.bytesRead = this.histogram("bytes-read");
        this.bytesWritten = this.histogram("bytes-written");
    }

    public void close() {
        this.closed = true;
        this.removeAll();
    }

    public Timer.Context connected(SocketAddress remoteAddress, String remoteName) {
        this.openConnections.inc();
        this.counter("open-connections", remoteAddress.host()).inc();
        if (this.closed) {
            this.removeAll();
        }
        return this.connections.time();
    }

    public void disconnected(Timer.Context ctx, SocketAddress remoteAddress) {
        this.openConnections.dec();
        ctx.stop();
        Counter counter = this.counter("open-connections", remoteAddress.host());
        counter.dec();
        if (counter.getCount() == 0L) {
            this.remove("open-connections", remoteAddress.host());
        }
        if (this.closed) {
            this.removeAll();
        }
    }

    public void bytesRead(Timer.Context socketMetric, SocketAddress remoteAddress, long numberOfBytes) {
        this.bytesRead.update(numberOfBytes);
    }

    public void bytesWritten(Timer.Context socketMetric, SocketAddress remoteAddress, long numberOfBytes) {
        this.bytesWritten.update(numberOfBytes);
    }

    public void exceptionOccurred(Timer.Context socketMetric, SocketAddress remoteAddress, Throwable t) {
        this.exceptions.inc();
    }

    protected long connections() {
        if (this.openConnections == null) {
            return 0L;
        }
        return this.openConnections.getCount();
    }

    protected static String addressName(SocketAddress address) {
        if (address == null) {
            return null;
        }
        return address.host() + ":" + address.port();
    }
}

