/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.dropwizard;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.dropwizard.MatchType;

@DataObject
public class Match {
    public static final MatchType DEFAULT_TYPE = MatchType.EQUALS;
    private String value;
    private MatchType type;

    public Match() {
        this.type = DEFAULT_TYPE;
    }

    public Match(Match other) {
        this.value = other.value;
        this.type = other.type;
    }

    public Match(JsonObject json) {
        this.value = json.getString("value");
        this.type = MatchType.valueOf(json.getString("type", DEFAULT_TYPE.name()));
    }

    public String getValue() {
        return this.value;
    }

    public Match setValue(String value) {
        this.value = value;
        return this;
    }

    public MatchType getType() {
        return this.type;
    }

    public Match setType(MatchType type) {
        this.type = type;
        return this;
    }
}

