/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.dropwizard.impl;

import com.codahale.metrics.Counter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.SharedMetricRegistries;
import io.vertx.core.Handler;
import io.vertx.core.Verticle;
import io.vertx.core.VertxOptions;
import io.vertx.core.datagram.DatagramSocket;
import io.vertx.core.datagram.DatagramSocketOptions;
import io.vertx.core.eventbus.EventBus;
import io.vertx.core.http.HttpClient;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.HttpServer;
import io.vertx.core.http.HttpServerOptions;
import io.vertx.core.net.NetClient;
import io.vertx.core.net.NetClientOptions;
import io.vertx.core.net.NetServer;
import io.vertx.core.net.NetServerOptions;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.spi.metrics.DatagramSocketMetrics;
import io.vertx.core.spi.metrics.EventBusMetrics;
import io.vertx.core.spi.metrics.HttpClientMetrics;
import io.vertx.core.spi.metrics.HttpServerMetrics;
import io.vertx.core.spi.metrics.PoolMetrics;
import io.vertx.core.spi.metrics.TCPMetrics;
import io.vertx.core.spi.metrics.VertxMetrics;
import io.vertx.ext.dropwizard.DropwizardMetricsOptions;
import io.vertx.ext.dropwizard.impl.AbstractMetrics;
import io.vertx.ext.dropwizard.impl.DatagramSocketMetricsImpl;
import io.vertx.ext.dropwizard.impl.EventBusMetricsImpl;
import io.vertx.ext.dropwizard.impl.HttpClientMetricsImpl;
import io.vertx.ext.dropwizard.impl.HttpClientReporter;
import io.vertx.ext.dropwizard.impl.HttpServerMetricsImpl;
import io.vertx.ext.dropwizard.impl.PoolMetricsImpl;
import io.vertx.ext.dropwizard.impl.RegistryHelper;
import io.vertx.ext.dropwizard.impl.TCPMetricsImpl;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;

class VertxMetricsImpl
extends AbstractMetrics
implements VertxMetrics {
    static final String BASE_NAME = "vertx";
    private final DropwizardMetricsOptions options;
    private final Counter timers;
    private final Counter verticles;
    private Handler<Void> doneHandler;
    private final boolean shutdown;
    private final Map<String, HttpClientReporter> clientReporters = new HashMap<String, HttpClientReporter>();

    VertxMetricsImpl(MetricRegistry registry, boolean shutdown, VertxOptions options, DropwizardMetricsOptions metricsOptions) {
        super(registry, BASE_NAME);
        this.timers = this.counter("timers");
        this.options = metricsOptions;
        this.verticles = this.counter("verticles");
        this.shutdown = shutdown;
        this.gauge(() -> ((VertxOptions)options).getEventLoopPoolSize(), "event-loop-size");
        this.gauge(() -> ((VertxOptions)options).getWorkerPoolSize(), "worker-pool-size");
        if (options.isClustered()) {
            this.gauge(() -> ((VertxOptions)options).getClusterHost(), "cluster-host");
            this.gauge(() -> ((VertxOptions)options).getClusterPort(), "cluster-port");
        }
    }

    DropwizardMetricsOptions getOptions() {
        return this.options;
    }

    @Override
    String projectName(String name) {
        return name;
    }

    public void verticleDeployed(Verticle verticle) {
        this.verticles.inc();
        this.counter("verticles", VertxMetricsImpl.verticleName(verticle)).inc();
    }

    public void verticleUndeployed(Verticle verticle) {
        this.verticles.dec();
        this.counter("verticles", VertxMetricsImpl.verticleName(verticle)).dec();
    }

    public void timerCreated(long id) {
        this.timers.inc();
    }

    public void timerEnded(long id, boolean cancelled) {
        this.timers.dec();
    }

    public EventBusMetrics createMetrics(EventBus eventBus) {
        return new EventBusMetricsImpl(this, this.nameOf("eventbus"), this.options);
    }

    public HttpServerMetrics<?, ?, ?> createMetrics(HttpServer server, SocketAddress localAddress, HttpServerOptions options) {
        return new HttpServerMetricsImpl(this.registry, this.nameOf("http.servers"), this.options.getMonitoredHttpServerUris(), localAddress);
    }

    public synchronized HttpClientMetrics<?, ?, ?, ?, ?> createMetrics(HttpClient client, HttpClientOptions options) {
        String name = options.getMetricsName();
        String baseName = name != null && name.length() > 0 ? this.nameOf("http.clients", name) : "http.clients";
        HttpClientReporter reporter = this.clientReporters.computeIfAbsent(baseName, n -> new HttpClientReporter(this.registry, baseName, null));
        return new HttpClientMetricsImpl(this, reporter, options, this.options.getMonitoredHttpClientUris());
    }

    synchronized void closed(HttpClientMetricsImpl metrics) {
        HttpClientReporter reporter = metrics.clientReporter;
        if (reporter.decMaxPoolSize(metrics.maxPoolSize)) {
            this.clientReporters.remove(reporter.baseName);
            reporter.close();
        }
    }

    public TCPMetrics<?> createMetrics(NetServer server, SocketAddress localAddress, NetServerOptions options) {
        String baseName = MetricRegistry.name((String)this.nameOf("net.servers"), (String[])new String[]{TCPMetricsImpl.addressName(localAddress)});
        return new TCPMetricsImpl(this.registry, baseName);
    }

    public TCPMetrics<?> createMetrics(NetClient client, NetClientOptions options) {
        String baseName = options.getMetricsName() != null ? this.nameOf("net.clients", options.getMetricsName()) : this.nameOf("net.clients");
        return new TCPMetricsImpl(this.registry, baseName);
    }

    public DatagramSocketMetrics createMetrics(DatagramSocket socket, DatagramSocketOptions options) {
        return new DatagramSocketMetricsImpl(this, this.nameOf("datagram"));
    }

    public <P> PoolMetrics<?> createMetrics(P pool, String poolType, String poolName, int maxPoolSize) {
        String baseName = this.nameOf("pools", poolType, poolName);
        return new PoolMetricsImpl(this.registry, baseName, maxPoolSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        ArrayList<HttpClientReporter> reporters;
        if (this.shutdown) {
            RegistryHelper.shutdown(this.registry);
            if (this.options.getRegistryName() != null) {
                SharedMetricRegistries.remove((String)this.options.getRegistryName());
            }
        }
        VertxMetricsImpl vertxMetricsImpl = this;
        synchronized (vertxMetricsImpl) {
            reporters = new ArrayList<HttpClientReporter>(this.clientReporters.values());
        }
        for (HttpClientReporter reporter : reporters) {
            reporter.close();
        }
        if (this.doneHandler != null) {
            this.doneHandler.handle(null);
        }
    }

    public boolean isMetricsEnabled() {
        return true;
    }

    void setDoneHandler(Handler<Void> handler) {
        this.doneHandler = handler;
    }

    private static String verticleName(Verticle verticle) {
        return verticle.getClass().getName();
    }
}

