/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.dropwizard.impl;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Timer;
import io.vertx.ext.dropwizard.impl.HttpClientReporter;

public class EndpointMetric {
    final String name;
    final Timer queueDelay;
    final Counter queueSize;
    final Counter openConnections;
    final Timer usage;
    final Timer ttfb;
    final Counter inUse;

    public EndpointMetric(HttpClientReporter reporter, String host, int port) {
        this.name = host + ":" + port;
        this.queueDelay = reporter.timer("endpoint", this.name, "queue-delay");
        this.queueSize = reporter.counter("endpoint", this.name, "queue-size");
        this.openConnections = reporter.counter("endpoint", this.name, "open-netsockets");
        this.usage = reporter.timer("endpoint", this.name, "usage");
        this.ttfb = reporter.timer("endpoint", this.name, "ttfb");
        this.inUse = reporter.counter("endpoint", this.name, "in-use");
    }

    void close(HttpClientReporter reporter) {
        reporter.remove("endpoint", this.name);
    }
}

