/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.dropwizard.impl.shell;

import io.vertx.core.Vertx;
import io.vertx.core.cli.annotations.Argument;
import io.vertx.core.cli.annotations.Description;
import io.vertx.core.cli.annotations.Name;
import io.vertx.core.cli.annotations.Summary;
import io.vertx.core.json.JsonObject;
import io.vertx.ext.dropwizard.MetricsService;
import io.vertx.ext.shell.command.AnnotatedCommand;
import io.vertx.ext.shell.command.CommandProcess;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Formatter;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Name(value="metrics-histogram")
@Summary(value="Show histogram metrics for the current Vert.x instance in real time")
public class MetricsHistogram
extends AnnotatedCommand {
    private String name;
    private List<String> columns;
    private List<String> headerColumns = new ArrayList<String>(Arrays.asList("NAME", "COUNT", "MEDIAN"));
    private List<String> availableColumns = Arrays.asList("MIN", "MAX", "75%", "95%", "99%", "99.9%");

    @Argument(index=0, argName="name")
    @Description(value="The histogram metrics name, can be a prefix or a precise name")
    public void setName(String name) {
        this.name = name;
    }

    @Argument(index=1, argName="columns", required=false)
    @Description(value="The configurable histogram metrics columns to show [min max 75% 95% 98% 99% 99.9%]")
    public void setColumns(List<String> columns) {
        this.columns = columns;
    }

    public void process(CommandProcess process) {
        Vertx vertx = process.vertx();
        MetricsService metrics = MetricsService.create(vertx);
        this.headerColumns.addAll(this.columns.stream().map(String::trim).distinct().map(String::toUpperCase).filter(f -> this.availableColumns.contains(f)).collect(Collectors.toList()));
        StringBuilder output = new StringBuilder();
        Formatter formatter = new Formatter(output);
        StringBuilder format = new StringBuilder();
        format.append(" ");
        format.append("%1$-50s %2$-10s %3$-10s");
        if (this.headerColumns.size() > 3) {
            for (int i2 = 3; i2 < this.headerColumns.size(); ++i2) {
                format.append(" %" + (i2 + 1) + "$-10s");
            }
        }
        long timer = vertx.setPeriodic(1000L, id -> {
            Map<String, Object> histogramMetrics = metrics.getMetricsSnapshot(this.name).stream().filter(e -> ((JsonObject)e.getValue()).getString("type").equals("histogram")).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            ArrayList<String> histogramKeys = new ArrayList<String>(histogramMetrics.keySet());
            for (int i = 1; i <= process.height(); ++i) {
                output.append("\u001b[").append(i).append(";1H\u001b[K");
                if (i == 1) {
                    formatter.format(format.toString(), this.headerColumns.toArray());
                    continue;
                }
                int index = i - 2;
                if (index >= histogramKeys.size()) continue;
                String key = (String)histogramKeys.get(index);
                JsonObject data = (JsonObject)histogramMetrics.get(key);
                ArrayList<Object> dataColumns = new ArrayList<Object>();
                dataColumns.add(key);
                for (String header : this.headerColumns) {
                    if (header.equals("NAME")) continue;
                    dataColumns.add(data.getValue(header.toLowerCase()));
                }
                formatter.format(format.toString(), dataColumns.toArray());
            }
            process.write(output.toString());
        });
        process.interruptHandler(i -> {
            vertx.cancelTimer(timer);
            process.end();
        });
    }
}

