/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.dropwizard.impl;

import com.codahale.metrics.Counter;
import com.codahale.metrics.Timer;
import io.vertx.core.spi.metrics.ClientMetrics;
import io.vertx.core.spi.observability.HttpRequest;
import io.vertx.core.spi.observability.HttpResponse;
import io.vertx.ext.dropwizard.impl.HttpClientReporter;
import io.vertx.ext.dropwizard.impl.HttpClientRequestMetric;
import io.vertx.ext.dropwizard.impl.Matcher;
import java.util.concurrent.TimeUnit;

public class EndpointMetrics
implements ClientMetrics<HttpClientRequestMetric, Timer.Context, HttpRequest, HttpResponse> {
    final HttpClientReporter reporter;
    final Matcher uriMatcher;
    final Timer queueDelay;
    final Counter queueSize;
    final Counter openConnections;
    final Timer usage;
    final Timer ttfb;
    final Counter inUse;

    public EndpointMetrics(HttpClientReporter reporter, String name, Matcher uriMatcher) {
        this.reporter = reporter;
        this.queueDelay = reporter.timer("endpoint", name, "queue-delay");
        this.queueSize = reporter.counter("endpoint", name, "queue-size");
        this.openConnections = reporter.counter("endpoint", name, "open-netsockets");
        this.usage = reporter.timer("endpoint", name, "usage");
        this.ttfb = reporter.timer("endpoint", name, "ttfb");
        this.inUse = reporter.counter("endpoint", name, "in-use");
        this.uriMatcher = uriMatcher;
    }

    public Timer.Context enqueueRequest() {
        this.queueSize.inc();
        return this.queueDelay.time();
    }

    public void dequeueRequest(Timer.Context taskMetric) {
        this.queueSize.dec();
        taskMetric.stop();
    }

    public HttpClientRequestMetric requestBegin(String uri, HttpRequest request) {
        this.inUse.inc();
        return new HttpClientRequestMetric(this, request.method(), request.uri());
    }

    public void requestEnd(HttpClientRequestMetric requestMetric, long bytesWritten) {
        requestMetric.requestEnd = System.nanoTime();
    }

    public void requestReset(HttpClientRequestMetric requestMetric) {
        this.inUse.inc();
    }

    public void responseBegin(HttpClientRequestMetric requestMetric, HttpResponse response) {
        long waitTime = System.nanoTime() - requestMetric.requestEnd;
        requestMetric.response = response;
        this.ttfb.update(waitTime, TimeUnit.NANOSECONDS);
    }

    public void responseEnd(HttpClientRequestMetric requestMetric, long bytesRead) {
        long duration = this.reporter.end(requestMetric, requestMetric.response.statusCode(), this.uriMatcher);
        this.inUse.dec();
        this.usage.update(duration, TimeUnit.NANOSECONDS);
    }
}

