/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.dropwizard.impl;

import com.codahale.metrics.MetricRegistry;
import io.vertx.core.http.HttpMethod;
import io.vertx.core.http.ServerWebSocket;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.spi.metrics.HttpServerMetrics;
import io.vertx.core.spi.observability.HttpRequest;
import io.vertx.core.spi.observability.HttpResponse;
import io.vertx.ext.dropwizard.Match;
import io.vertx.ext.dropwizard.impl.HttpMetricsImpl;
import io.vertx.ext.dropwizard.impl.HttpRequestMetric;
import io.vertx.ext.dropwizard.impl.Matcher;
import io.vertx.ext.dropwizard.impl.WebSocketMetric;
import java.util.List;

class HttpServerMetricsImpl
extends HttpMetricsImpl
implements HttpServerMetrics<HttpRequestMetric, WebSocketMetric, Long> {
    private final Matcher uriMatcher;

    HttpServerMetricsImpl(MetricRegistry registry, String baseName, List<Match> monitoredUris, SocketAddress localAddress) {
        super(registry, baseName, localAddress);
        this.uriMatcher = new Matcher(monitoredUris);
    }

    public HttpRequestMetric requestBegin(Long socketMetric, HttpRequest request) {
        return new HttpRequestMetric(request.method(), request.uri());
    }

    public void responseBegin(HttpRequestMetric requestMetric, HttpResponse response) {
        requestMetric.response = response;
    }

    public WebSocketMetric connected(Long socketMetric, HttpRequestMetric requestMetric, ServerWebSocket serverWebSocket) {
        return this.createWebSocketMetric();
    }

    public void responseEnd(HttpRequestMetric requestMetric, long bytesWritten) {
        this.end(requestMetric, requestMetric.response.statusCode(), this.uriMatcher);
    }

    public void requestReset(HttpRequestMetric requestMetric) {
    }

    public HttpRequestMetric responsePushed(Long socketMetric, HttpMethod method, String uri, HttpResponse response) {
        return new HttpRequestMetric(method, uri);
    }

    public void disconnected(WebSocketMetric serverWebSocketMetric) {
        this.disconnect(serverWebSocketMetric);
    }
}

