/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.dropwizard.impl;

import com.codahale.metrics.Timer;
import io.vertx.core.http.HttpClientOptions;
import io.vertx.core.http.WebSocket;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.spi.metrics.ClientMetrics;
import io.vertx.core.spi.metrics.HttpClientMetrics;
import io.vertx.core.spi.observability.HttpRequest;
import io.vertx.core.spi.observability.HttpResponse;
import io.vertx.ext.dropwizard.Match;
import io.vertx.ext.dropwizard.impl.AbstractMetrics;
import io.vertx.ext.dropwizard.impl.EndpointMetrics;
import io.vertx.ext.dropwizard.impl.HttpClientReporter;
import io.vertx.ext.dropwizard.impl.HttpClientRequestMetric;
import io.vertx.ext.dropwizard.impl.Matcher;
import io.vertx.ext.dropwizard.impl.VertxMetricsImpl;
import io.vertx.ext.dropwizard.impl.WebSocketMetric;
import java.util.List;

class HttpClientMetricsImpl
extends AbstractMetrics
implements HttpClientMetrics<HttpClientRequestMetric, WebSocketMetric, Long, Timer.Context> {
    private final VertxMetricsImpl owner;
    private final Matcher uriMatcher;
    private final Matcher endpointMatcher;
    final HttpClientReporter clientReporter;
    final int maxPoolSize;

    HttpClientMetricsImpl(VertxMetricsImpl owner, HttpClientReporter clientReporter, HttpClientOptions options, List<Match> monitoredUris, List<Match> monitoredEndpoints) {
        super(clientReporter.registry, clientReporter.baseName);
        this.owner = owner;
        this.clientReporter = clientReporter;
        this.uriMatcher = new Matcher(monitoredUris);
        this.endpointMatcher = new Matcher(monitoredEndpoints);
        this.maxPoolSize = options.getMaxPoolSize();
        clientReporter.incMaxPoolSize(this.maxPoolSize);
    }

    public ClientMetrics<HttpClientRequestMetric, Timer.Context, HttpRequest, HttpResponse> createEndpointMetrics(SocketAddress remoteAddress, int maxPoolSize) {
        String name = remoteAddress.toString();
        if (this.endpointMatcher.matches(name) != null) {
            return new EndpointMetrics(this.clientReporter, name, this.uriMatcher);
        }
        return null;
    }

    public void endpointConnected(ClientMetrics<HttpClientRequestMetric, Timer.Context, ?, ?> endpointMetric) {
        if (endpointMetric instanceof EndpointMetrics) {
            ((EndpointMetrics)endpointMetric).openConnections.inc();
        }
    }

    public void endpointDisconnected(ClientMetrics<HttpClientRequestMetric, Timer.Context, ?, ?> endpointMetric) {
        if (endpointMetric instanceof EndpointMetrics) {
            ((EndpointMetrics)endpointMetric).openConnections.dec();
        }
    }

    public WebSocketMetric connected(WebSocket webSocket) {
        return this.clientReporter.createWebSocketMetric();
    }

    public void disconnected(WebSocketMetric webSocketMetric) {
        this.clientReporter.disconnect(webSocketMetric);
    }

    public Long connected(SocketAddress remoteAddress, String remoteName) {
        return this.clientReporter.connected(remoteAddress, remoteName);
    }

    public void disconnected(Long socketMetric, SocketAddress remoteAddress) {
        this.clientReporter.disconnected(socketMetric, remoteAddress);
    }

    public void bytesRead(Long socketMetric, SocketAddress remoteAddress, long numberOfBytes) {
        this.clientReporter.bytesRead(socketMetric, remoteAddress, numberOfBytes);
    }

    public void bytesWritten(Long socketMetric, SocketAddress remoteAddress, long numberOfBytes) {
        this.clientReporter.bytesWritten(socketMetric, remoteAddress, numberOfBytes);
    }

    public void exceptionOccurred(Long socketMetric, SocketAddress remoteAddress, Throwable t) {
        this.clientReporter.exceptionOccurred(socketMetric, remoteAddress, t);
    }

    public void close() {
        this.owner.closed(this);
    }
}

