/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.dropwizard;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.json.impl.JsonUtil;
import io.vertx.ext.dropwizard.DropwizardMetricsOptions;
import io.vertx.ext.dropwizard.Match;
import java.util.Base64;
import java.util.Map;

public class DropwizardMetricsOptionsConverter {
    private static final Base64.Decoder BASE64_DECODER = JsonUtil.BASE64_DECODER;
    private static final Base64.Encoder BASE64_ENCODER = JsonUtil.BASE64_ENCODER;

    public static void fromJson(Iterable<Map.Entry<String, Object>> json, DropwizardMetricsOptions obj) {
        for (Map.Entry<String, Object> member : json) {
            switch (member.getKey()) {
                case "baseName": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setBaseName((String)member.getValue());
                    break;
                }
                case "configPath": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setConfigPath((String)member.getValue());
                    break;
                }
                case "enabled": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setEnabled((Boolean)member.getValue());
                    break;
                }
                case "jmxDomain": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setJmxDomain((String)member.getValue());
                    break;
                }
                case "jmxEnabled": {
                    if (!(member.getValue() instanceof Boolean)) break;
                    obj.setJmxEnabled((Boolean)member.getValue());
                    break;
                }
                case "monitoredEventBusHandlers": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof JsonObject) {
                            obj.addMonitoredEventBusHandler(new Match((JsonObject)item));
                        }
                    });
                    break;
                }
                case "monitoredHttpClientEndpoint": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    break;
                }
                case "monitoredHttpClientEndpoints": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof JsonObject) {
                            obj.addMonitoredHttpClientEndpoint(new Match((JsonObject)item));
                        }
                    });
                    break;
                }
                case "monitoredHttpClientUris": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof JsonObject) {
                            obj.addMonitoredHttpClientUri(new Match((JsonObject)item));
                        }
                    });
                    break;
                }
                case "monitoredHttpServerRoutes": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof JsonObject) {
                            obj.addMonitoredHttpServerRoute(new Match((JsonObject)item));
                        }
                    });
                    break;
                }
                case "monitoredHttpServerUris": {
                    if (!(member.getValue() instanceof JsonArray)) break;
                    ((Iterable)member.getValue()).forEach(item -> {
                        if (item instanceof JsonObject) {
                            obj.addMonitoredHttpServerUri(new Match((JsonObject)item));
                        }
                    });
                    break;
                }
                case "registryName": {
                    if (!(member.getValue() instanceof String)) break;
                    obj.setRegistryName((String)member.getValue());
                }
            }
        }
    }

    public static void toJson(DropwizardMetricsOptions obj, JsonObject json) {
        DropwizardMetricsOptionsConverter.toJson(obj, json.getMap());
    }

    public static void toJson(DropwizardMetricsOptions obj, Map<String, Object> json) {
        JsonArray array;
        if (obj.getBaseName() != null) {
            json.put("baseName", obj.getBaseName());
        }
        if (obj.getConfigPath() != null) {
            json.put("configPath", obj.getConfigPath());
        }
        json.put("enabled", obj.isEnabled());
        if (obj.getJmxDomain() != null) {
            json.put("jmxDomain", obj.getJmxDomain());
        }
        json.put("jmxEnabled", obj.isJmxEnabled());
        if (obj.getMonitoredEventBusHandlers() != null) {
            array = new JsonArray();
            obj.getMonitoredEventBusHandlers().forEach(item -> array.add((Object)item.toJson()));
            json.put("monitoredEventBusHandlers", array);
        }
        if (obj.getMonitoredHttpClientEndpoint() != null) {
            array = new JsonArray();
            obj.getMonitoredHttpClientEndpoint().forEach(item -> array.add((Object)item.toJson()));
            json.put("monitoredHttpClientEndpoint", array);
        }
        if (obj.getMonitoredHttpClientUris() != null) {
            array = new JsonArray();
            obj.getMonitoredHttpClientUris().forEach(item -> array.add((Object)item.toJson()));
            json.put("monitoredHttpClientUris", array);
        }
        if (obj.getMonitoredHttpServerRoutes() != null) {
            array = new JsonArray();
            obj.getMonitoredHttpServerRoutes().forEach(item -> array.add((Object)item.toJson()));
            json.put("monitoredHttpServerRoutes", array);
        }
        if (obj.getMonitoredHttpServerUris() != null) {
            array = new JsonArray();
            obj.getMonitoredHttpServerUris().forEach(item -> array.add((Object)item.toJson()));
            json.put("monitoredHttpServerUris", array);
        }
        if (obj.getRegistryName() != null) {
            json.put("registryName", obj.getRegistryName());
        }
    }
}

