/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.dropwizard;

import com.codahale.metrics.MetricRegistry;
import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.core.metrics.MetricsOptions;
import io.vertx.ext.dropwizard.DropwizardMetricsOptionsConverter;
import io.vertx.ext.dropwizard.Match;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@DataObject(generateConverter=true, inheritConverter=true)
public class DropwizardMetricsOptions
extends MetricsOptions {
    public static final boolean DEFAULT_JMX_ENABLED = false;
    public static final List<Match> DEFAULT_MONITORED_HANDLERS = null;
    public static final List<Match> DEFAULT_MONITORED_HTTP_SERVER_URIS = null;
    public static final List<Match> DEFAULT_MONITORED_HTTP_SERVER_ROUTES = null;
    public static final List<Match> DEFAULT_MONITORED_HTTP_CLIENT_URIS = null;
    public static final List<Match> DEFAULT_MONITORED_HTTP_CLIENT_ENDPOINTS = null;
    private String registryName;
    private boolean jmxEnabled;
    private String jmxDomain;
    private List<Match> monitoredEventBusHandlers;
    private List<Match> monitoredHttpServerUris;
    private List<Match> monitoredHttpServerRoutes;
    private List<Match> monitoredHttpClientUris;
    private List<Match> monitoredHttpClientEndpoints;
    private String configPath;
    private String baseName;
    private MetricRegistry metricRegistry;

    public DropwizardMetricsOptions() {
        this.jmxEnabled = false;
        this.monitoredEventBusHandlers = DEFAULT_MONITORED_HANDLERS;
        this.monitoredHttpServerUris = DEFAULT_MONITORED_HTTP_SERVER_URIS;
        this.monitoredHttpServerRoutes = DEFAULT_MONITORED_HTTP_SERVER_ROUTES;
        this.monitoredHttpClientUris = DEFAULT_MONITORED_HTTP_CLIENT_URIS;
        this.monitoredHttpClientEndpoints = DEFAULT_MONITORED_HTTP_CLIENT_ENDPOINTS;
    }

    public DropwizardMetricsOptions(MetricsOptions other) {
        super(other);
        this.jmxEnabled = false;
        this.monitoredEventBusHandlers = DEFAULT_MONITORED_HANDLERS;
        this.monitoredHttpServerUris = DEFAULT_MONITORED_HTTP_SERVER_URIS;
        this.monitoredHttpServerRoutes = DEFAULT_MONITORED_HTTP_SERVER_ROUTES;
        this.monitoredHttpClientUris = DEFAULT_MONITORED_HTTP_CLIENT_URIS;
        this.monitoredHttpClientEndpoints = DEFAULT_MONITORED_HTTP_CLIENT_ENDPOINTS;
    }

    public DropwizardMetricsOptions(DropwizardMetricsOptions other) {
        super((MetricsOptions)other);
        this.baseName = other.getBaseName();
        this.registryName = other.getRegistryName();
        this.jmxEnabled = other.isJmxEnabled();
        this.jmxDomain = other.getJmxDomain();
        this.configPath = other.getConfigPath();
        this.monitoredEventBusHandlers = other.monitoredEventBusHandlers == null ? null : new ArrayList<Match>(other.monitoredEventBusHandlers);
        this.monitoredHttpServerUris = other.monitoredHttpServerUris == null ? null : new ArrayList<Match>(other.monitoredHttpServerUris);
        this.monitoredHttpServerRoutes = other.monitoredHttpServerRoutes == null ? null : new ArrayList<Match>(other.monitoredHttpServerRoutes);
        this.monitoredHttpClientUris = other.monitoredHttpClientUris == null ? null : new ArrayList<Match>(other.monitoredHttpClientUris);
        this.monitoredHttpClientEndpoints = other.monitoredHttpClientEndpoints == null ? null : new ArrayList<Match>(other.monitoredHttpClientEndpoints);
        this.metricRegistry = other.getMetricRegistry();
    }

    public DropwizardMetricsOptions(JsonObject json) {
        this();
        DropwizardMetricsOptionsConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
    }

    private List<Match> loadMonitored(String arrayField, JsonObject json) {
        ArrayList<Match> list = new ArrayList<Match>();
        JsonArray monitored = json.getJsonArray(arrayField, new JsonArray());
        monitored.forEach(object -> {
            if (object instanceof JsonObject) {
                list.add(new Match((JsonObject)object));
            }
        });
        return list;
    }

    public String getRegistryName() {
        return this.registryName;
    }

    public DropwizardMetricsOptions setRegistryName(String registryName) {
        this.registryName = registryName;
        return this;
    }

    public boolean isJmxEnabled() {
        return this.jmxEnabled;
    }

    public DropwizardMetricsOptions setJmxEnabled(boolean jmxEnabled) {
        this.jmxEnabled = jmxEnabled;
        if (jmxEnabled) {
            this.setEnabled(true);
        }
        return this;
    }

    public String getJmxDomain() {
        return this.jmxDomain;
    }

    public DropwizardMetricsOptions setJmxDomain(String jmxDomain) {
        this.jmxDomain = jmxDomain;
        return this;
    }

    public List<Match> getMonitoredEventBusHandlers() {
        return this.monitoredEventBusHandlers;
    }

    public DropwizardMetricsOptions addMonitoredEventBusHandler(Match match) {
        if (this.monitoredEventBusHandlers == null) {
            this.monitoredEventBusHandlers = new ArrayList<Match>();
        }
        this.monitoredEventBusHandlers.add(match);
        return this;
    }

    public List<Match> getMonitoredHttpServerUris() {
        return this.monitoredHttpServerUris;
    }

    public DropwizardMetricsOptions addMonitoredHttpServerUri(Match match) {
        if (this.monitoredHttpServerUris == null) {
            this.monitoredHttpServerUris = new ArrayList<Match>();
        }
        this.monitoredHttpServerUris.add(match);
        return this;
    }

    public List<Match> getMonitoredHttpServerRoutes() {
        return this.monitoredHttpServerRoutes;
    }

    public DropwizardMetricsOptions addMonitoredHttpServerRoute(Match match) {
        if (this.monitoredHttpServerRoutes == null) {
            this.monitoredHttpServerRoutes = new ArrayList<Match>();
        }
        this.monitoredHttpServerRoutes.add(match);
        return this;
    }

    public List<Match> getMonitoredHttpClientUris() {
        return this.monitoredHttpClientUris;
    }

    public DropwizardMetricsOptions setEnabled(boolean enable) {
        return (DropwizardMetricsOptions)super.setEnabled(enable);
    }

    public String getConfigPath() {
        return this.configPath;
    }

    public DropwizardMetricsOptions setConfigPath(String configPath) {
        this.configPath = configPath;
        return this;
    }

    public DropwizardMetricsOptions addMonitoredHttpClientUri(Match match) {
        if (this.monitoredHttpClientUris == null) {
            this.monitoredHttpClientUris = new ArrayList<Match>();
        }
        this.monitoredHttpClientUris.add(match);
        return this;
    }

    public DropwizardMetricsOptions addMonitoredHttpClientEndpoint(Match match) {
        if (this.monitoredHttpClientEndpoints == null) {
            this.monitoredHttpClientEndpoints = new ArrayList<Match>();
        }
        this.monitoredHttpClientEndpoints.add(match);
        return this;
    }

    public List<Match> getMonitoredHttpClientEndpoint() {
        return this.monitoredHttpClientEndpoints;
    }

    public DropwizardMetricsOptions setBaseName(String baseName) {
        this.baseName = baseName;
        return this;
    }

    public String getBaseName() {
        return this.baseName;
    }

    public MetricRegistry getMetricRegistry() {
        return this.metricRegistry;
    }

    public DropwizardMetricsOptions setMetricRegistry(MetricRegistry metricRegistry) {
        this.metricRegistry = metricRegistry;
        return this;
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        DropwizardMetricsOptionsConverter.toJson(this, json);
        return json;
    }
}

