/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.dropwizard;

import io.vertx.core.Vertx;
import io.vertx.core.metrics.Measured;
import io.vertx.ext.dropwizard.impl.AbstractMetrics;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.BiPredicate;

public class ScheduledMetricsConsumer {
    private final Vertx vertx;
    private final AbstractMetrics measured;
    private BiPredicate<String, Object> filter = (name, metric) -> true;
    private volatile long timerId = -1L;

    public ScheduledMetricsConsumer(Vertx vertx) {
        this(vertx, (Measured)vertx);
    }

    public ScheduledMetricsConsumer(Vertx vertx, Measured measured) {
        this.vertx = vertx;
        this.measured = AbstractMetrics.unwrap(measured);
    }

    public ScheduledMetricsConsumer filter(BiPredicate<String, Object> filter) {
        if (this.timerId != -1L) {
            throw new IllegalStateException("Cannot set filter while metrics consumer is running.");
        }
        this.filter = filter;
        return this;
    }

    public void start(long delay, TimeUnit unit, BiConsumer<String, Object> consumer) {
        this.timerId = this.vertx.setPeriodic(unit.toMillis(delay), tid -> this.measured.metrics().getMap().forEach((name, metric) -> {
            System.out.println("maybe " + name);
            if (this.filter.test((String)name, metric)) {
                System.out.println("sending " + name);
                consumer.accept((String)name, metric);
            }
        }));
    }

    public void stop() {
        this.vertx.cancelTimer(this.timerId);
        this.timerId = -1L;
    }
}

