/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.dropwizard.impl;

import com.codahale.metrics.Counter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.Timer;
import io.vertx.core.spi.metrics.ClientMetrics;
import io.vertx.ext.dropwizard.impl.AbstractMetrics;
import io.vertx.ext.dropwizard.impl.RequestMetric;
import io.vertx.ext.dropwizard.impl.VertxMetricsImpl;
import java.util.concurrent.TimeUnit;

public class DropwizardClientMetrics<Req, Resp>
extends AbstractMetrics
implements ClientMetrics<RequestMetric, Req, Resp> {
    final VertxMetricsImpl vertxMetrics;
    final Timer requests;
    final Timer ttfb;
    final Counter inUse;
    final int count;

    public DropwizardClientMetrics(VertxMetricsImpl vertxMetrics, MetricRegistry registry, String baseName, int count) {
        super(registry, baseName);
        this.vertxMetrics = vertxMetrics;
        this.requests = this.timer("requests");
        this.ttfb = this.timer("ttfb");
        this.inUse = this.counter("in-use");
        this.count = count;
    }

    private DropwizardClientMetrics(DropwizardClientMetrics<Req, Resp> that, int count) {
        super(that.registry, that.baseName);
        this.vertxMetrics = that.vertxMetrics;
        this.requests = that.requests;
        this.ttfb = that.ttfb;
        this.inUse = that.inUse;
        this.count = count;
    }

    DropwizardClientMetrics<Req, Resp> inc() {
        return new DropwizardClientMetrics<Req, Resp>(this, this.count + 1);
    }

    DropwizardClientMetrics<Req, Resp> dec() {
        return new DropwizardClientMetrics<Req, Resp>(this, this.count - 1);
    }

    public RequestMetric requestBegin(String uri, Req request) {
        this.inUse.inc();
        RequestMetric metric = new RequestMetric();
        metric.requestBegin = System.nanoTime();
        return metric;
    }

    public void requestEnd(RequestMetric metric) {
        metric.requestEnd = System.nanoTime();
    }

    public void responseBegin(RequestMetric requestMetric, Resp response) {
        long waitTime = System.nanoTime() - requestMetric.requestEnd;
        this.ttfb.update(waitTime, TimeUnit.NANOSECONDS);
    }

    public void requestReset(RequestMetric requestMetric) {
        this.inUse.inc();
    }

    public void responseEnd(RequestMetric requestMetric) {
        long duration = System.nanoTime() - requestMetric.requestBegin;
        this.inUse.dec();
        this.requests.update(duration, TimeUnit.NANOSECONDS);
    }

    public void close() {
        this.vertxMetrics.closed(this);
    }
}

