/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.dropwizard.impl;

import com.codahale.metrics.Counter;
import com.codahale.metrics.MetricRegistry;
import com.codahale.metrics.RatioGauge;
import com.codahale.metrics.Timer;
import io.vertx.core.spi.metrics.PoolMetrics;
import io.vertx.ext.dropwizard.impl.AbstractMetrics;

public class PoolMetricsImpl
extends AbstractMetrics
implements PoolMetrics<Timer.Context, Timer.Context> {
    private final Timer queueDelay;
    private final Counter queueSize = this.counter("queue-size");
    private final Timer usage;
    private final Counter inUse;

    public PoolMetricsImpl(MetricRegistry registry, String baseName, final int maxSize) {
        super(registry, baseName);
        this.queueDelay = this.timer("queue-delay");
        this.usage = this.timer("usage");
        this.inUse = this.counter("in-use");
        if (maxSize > 0) {
            RatioGauge gauge = new RatioGauge(){

                protected RatioGauge.Ratio getRatio() {
                    return RatioGauge.Ratio.of((double)PoolMetricsImpl.this.inUse.getCount(), (double)maxSize);
                }
            };
            this.gauge(gauge, new String[]{"pool-ratio"});
            this.gauge(() -> maxSize, "max-pool-size");
        }
    }

    public Timer.Context enqueue() {
        this.queueSize.inc();
        return this.queueDelay.time();
    }

    public void dequeue(Timer.Context queueMetric) {
        this.queueSize.dec();
        queueMetric.stop();
    }

    public Timer.Context begin() {
        this.inUse.inc();
        return this.usage.time();
    }

    public void end(Timer.Context usageMetric) {
        this.inUse.dec();
        usageMetric.stop();
    }

    public void close() {
        this.removeAll();
    }
}

