/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.eventbusclient;

public class AsyncResult<T> {
    private final T result;
    private final Throwable cause;

    private AsyncResult(T result, Throwable cause) {
        this.result = result;
        this.cause = cause;
    }

    static <Y> AsyncResult<Y> success(Y result) {
        return new AsyncResult<Y>(result, null);
    }

    static <Y> AsyncResult<Y> failure(Throwable cause) {
        return new AsyncResult<Object>(null, cause);
    }

    public boolean failed() {
        return this.cause != null;
    }

    public boolean succeeded() {
        return this.cause == null;
    }

    public T result() {
        return this.result;
    }

    public Throwable cause() {
        return this.cause;
    }
}

