/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.eventbusclient;

import io.netty.bootstrap.Bootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import io.vertx.eventbusclient.AsyncResult;
import io.vertx.eventbusclient.DeliveryOptions;
import io.vertx.eventbusclient.EventBusClientOptions;
import io.vertx.eventbusclient.Handler;
import io.vertx.eventbusclient.Message;
import io.vertx.eventbusclient.MessageConsumer;
import io.vertx.eventbusclient.MessageHandler;
import io.vertx.eventbusclient.json.JsonCodec;
import io.vertx.eventbusclient.transport.TcpTransport;
import io.vertx.eventbusclient.transport.Transport;
import io.vertx.eventbusclient.transport.WebSocketTransport;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;

public class EventBusClient {
    public static int MESSAGE_PRINT_LIMIT = 10000;
    private DeliveryOptions defaultOptions = new DeliveryOptions();
    private final Transport transport;
    private final NioEventLoopGroup group = new NioEventLoopGroup(1);
    private final Bootstrap bootstrap;
    private final EventBusClientOptions options;
    private final JsonCodec codec;
    private final InternalLogger logger;
    private final ConcurrentMap<String, HandlerList> consumerMap = new ConcurrentHashMap<String, HandlerList>();
    private io.netty.util.concurrent.ScheduledFuture<?> pingPeriodic;
    private ChannelFuture connectFuture;
    private Channel channel;
    private io.netty.util.concurrent.ScheduledFuture<?> reconnectFuture;
    private boolean initializedTransport;
    private boolean connected;
    private boolean closed = false;
    private int reconnectTries;
    private Handler<Handler<Void>> connectedHandler;
    private volatile Handler<Throwable> exceptionHandler;
    private Handler<Void> closeHandler;
    private final ArrayDeque<Handler<Transport>> pendingTasks = new ArrayDeque();

    private static JsonCodec defaultCodecOrDie() {
        JsonCodec codec = JsonCodec.DEFAULT;
        if (codec == null) {
            throw new IllegalStateException("No default codec found, check you added com.google.code.gson:gson or com.fasterxml.jackson.core:jackson-core to the classpath");
        }
        return codec;
    }

    public static EventBusClient tcp() {
        return EventBusClient.tcp(new EventBusClientOptions(), EventBusClient.defaultCodecOrDie());
    }

    public static EventBusClient tcp(EventBusClientOptions options) {
        return EventBusClient.tcp(options, EventBusClient.defaultCodecOrDie());
    }

    public static EventBusClient tcp(EventBusClientOptions options, JsonCodec codec) {
        if ((options = new EventBusClientOptions(options)).getPort() == -1) {
            options.setPort(7000);
        }
        return new EventBusClient(new TcpTransport(options), options, codec);
    }

    public static EventBusClient webSocket() {
        return EventBusClient.webSocket(new EventBusClientOptions(), EventBusClient.defaultCodecOrDie());
    }

    public static EventBusClient webSocket(JsonCodec codec) {
        return EventBusClient.webSocket(new EventBusClientOptions(), codec);
    }

    public static EventBusClient webSocket(EventBusClientOptions options) {
        return EventBusClient.webSocket(options, EventBusClient.defaultCodecOrDie());
    }

    public static EventBusClient webSocket(EventBusClientOptions options, JsonCodec codec) {
        if ((options = new EventBusClientOptions(options)).getPort() == -1) {
            options.setPort(80);
        }
        return new EventBusClient(new WebSocketTransport(options), options, codec);
    }

    private EventBusClient(Transport transport, EventBusClientOptions options, JsonCodec codec) {
        this.transport = transport;
        this.bootstrap = (Bootstrap)new Bootstrap().group((EventLoopGroup)this.group);
        this.options = options;
        this.codec = codec;
        this.logger = InternalLoggerFactory.getInstance(EventBusClient.class);
    }

    private synchronized void execute(Handler<Transport> task) {
        if (this.connected) {
            task.handle(this.transport);
        } else if (this.closed) {
            this.logger.error("This EventBusClient is closed.");
        } else {
            this.pendingTasks.add(task);
            if (this.connectFuture == null && this.reconnectFuture == null) {
                this.initializeTransport();
                this.logger.info("Connecting for executing task...");
                this.connectTransport();
            }
        }
    }

    private synchronized void initializeTransport() {
        if (this.initializedTransport) {
            return;
        }
        this.initializedTransport = true;
        this.transport.connectedHandler(new Handler<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handle(Void v) {
                EventBusClient eventBusClient = EventBusClient.this;
                synchronized (eventBusClient) {
                    EventBusClient.this.logger.info("Connected to bridge.");
                    EventBusClient.this.pingPeriodic = EventBusClient.this.group.next().scheduleAtFixedRate(new Runnable(){

                        @Override
                        public void run() {
                            Map<String, String> msg = Collections.singletonMap("type", "ping");
                            EventBusClient.this.send(EventBusClient.this.codec.encode(msg));
                        }
                    }, (long)EventBusClient.this.options.getPingInterval(), (long)EventBusClient.this.options.getPingInterval(), TimeUnit.MILLISECONDS);
                    EventBusClient.this.connected = true;
                    EventBusClient.this.reconnectTries = 0;
                    EventBusClient.this.channel = EventBusClient.this.connectFuture.channel();
                    EventBusClient.this.connectFuture = null;
                    if (EventBusClient.this.connectedHandler != null) {
                        EventBusClient.this.connectedHandler.handle(new Handler<Void>(){

                            @Override
                            public void handle(Void v) {
                                EventBusClient.this.handlePendingTasks();
                            }
                        });
                    } else {
                        EventBusClient.this.handlePendingTasks();
                    }
                }
            }
        });
        this.transport.messageHandler(new Handler<String>(){

            @Override
            public void handle(String json) {
                Map msg = EventBusClient.this.codec.decode(json, Map.class);
                EventBusClient.this.handleMsg(msg);
            }
        });
        this.transport.closeHandler(new Handler<Void>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void handle(Void event) {
                EventBusClient eventBusClient = EventBusClient.this;
                synchronized (eventBusClient) {
                    EventBusClient.this.logger.info("Closed connection to bridge.");
                    EventBusClient.this.connected = false;
                    EventBusClient.this.channel = null;
                    if (EventBusClient.this.closeHandler != null) {
                        EventBusClient.this.closeHandler.handle(null);
                    }
                    EventBusClient.this.pingPeriodic.cancel(false);
                    EventBusClient.this.autoReconnect();
                }
            }
        });
        this.bootstrap.channel(NioSocketChannel.class);
        this.bootstrap.handler((ChannelHandler)this.transport);
    }

    private synchronized void connectTransport() {
        if (this.connected || this.closed || this.connectFuture != null || this.reconnectFuture != null) {
            return;
        }
        String host = this.options.getHost();
        int port = this.options.getPort();
        if (this.options.getProxyHost() != null) {
            this.logger.info("Connecting to bridge at " + host + ":" + port + " (via " + this.options.getProxyHost() + ") using " + ((Object)((Object)this.transport)).getClass().getSimpleName() + "...");
        } else {
            this.logger.info("Connecting to bridge at " + host + ":" + port + " using " + ((Object)((Object)this.transport)).getClass().getSimpleName() + "...");
        }
        this.connectFuture = this.bootstrap.connect(host, port).addListener((GenericFutureListener)new GenericFutureListener<Future<? super Void>>(){

            public void operationComplete(Future future) {
                if (!future.isSuccess()) {
                    EventBusClient.this.handleError("Connecting to bridge failed.", future.cause());
                    EventBusClient.this.connectFuture = null;
                    EventBusClient.this.autoReconnect();
                }
            }
        });
    }

    private synchronized void autoReconnect() {
        if (!this.closed && this.reconnectFuture == null && this.options.isAutoReconnect() && (this.options.getMaxAutoReconnectTries() == 0 || this.reconnectTries < this.options.getMaxAutoReconnectTries())) {
            ++this.reconnectTries;
            int interval = this.options.getAutoReconnectInterval();
            this.logger.info("Auto reconnecting in " + interval + "ms (try number " + this.reconnectTries + ")...");
            this.reconnectFuture = this.group.next().schedule(new Runnable(){

                @Override
                public void run() {
                    EventBusClient.this.logger.info("Auto reconnecting...", (Object)EventBusClient.this.reconnectFuture);
                    EventBusClient.this.reconnectFuture = null;
                    EventBusClient.this.connectTransport();
                }
            }, (long)interval, TimeUnit.MILLISECONDS);
        }
    }

    private void handlePendingTasks() {
        Handler<Transport> t;
        for (String address : this.consumerMap.keySet()) {
            if (!((HandlerList)this.consumerMap.get(address)).reregisterAtServer) continue;
            this.logger.info("Registering address: " + address);
            this.send("register", address, null, this.defaultOptions == null ? null : this.defaultOptions.getHeaders(), null);
        }
        while ((t = this.pendingTasks.poll()) != null) {
            t.handle(this.transport);
        }
    }

    private void handleMsg(Map msg) {
        String type = (String)msg.get("type");
        if (type != null) {
            if ("message".equals(type) || "rec".equals(type)) {
                String address = (String)msg.get("address");
                if (address == null) {
                    return;
                }
                this.logger.info("Received message for address: " + address);
                HandlerList consumers = (HandlerList)this.consumerMap.get(address);
                if (consumers != null) {
                    Map body = (Map)msg.get("body");
                    Map msgHeaders = (Map)msg.get("headers");
                    Map headers = msgHeaders == null ? Collections.emptyMap() : msgHeaders;
                    String replyAddress = (String)msg.get("replyAddress");
                    consumers.send(new Message<Map>(this, address, headers, body, replyAddress));
                }
            } else if ("err".equals(type)) {
                String address = (String)msg.get("address");
                String message = (String)msg.get("message");
                if (address == null) {
                    this.logger.info("Received error without address present, probably the address was not found: " + message);
                    return;
                }
                HandlerList consumers = (HandlerList)this.consumerMap.get(address);
                if (consumers != null) {
                    consumers.fail(new RuntimeException(message));
                }
            }
        }
    }

    public EventBusClient setDefaultDeliveryOptions(DeliveryOptions defaultOptions) {
        this.defaultOptions = defaultOptions;
        return this;
    }

    public EventBusClient connect() {
        this.closed = false;
        this.initializeTransport();
        this.logger.info("Connecting as requested...");
        this.connectTransport();
        return this;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public void close() {
        if (this.channel != null) {
            this.channel.close();
        }
        this.closed = true;
    }

    public EventBusClient send(String address, Object message) {
        this.request(address, message, this.defaultOptions, null);
        return this;
    }

    public <T> EventBusClient request(String address, Object message, Handler<AsyncResult<Message<T>>> replyHandler) {
        return this.request(address, message, this.defaultOptions, replyHandler);
    }

    public EventBusClient send(String address, Object message, DeliveryOptions options) {
        return this.request(address, message, options, null);
    }

    public <T> EventBusClient request(String address, Object message, DeliveryOptions options, final Handler<AsyncResult<Message<T>>> replyHandler) {
        String replyAddr;
        if (replyHandler != null) {
            final AtomicBoolean registered = new AtomicBoolean(true);
            replyAddr = UUID.randomUUID().toString();
            final MessageHandler messageHandler = new MessageHandler<T>(){

                @Override
                public String address() {
                    return replyAddr;
                }

                @Override
                public void handleMessage(Message<T> msg) {
                    if (registered.compareAndSet(true, false)) {
                        this.cancelTimeout();
                        EventBusClient.this.unregister(this, false);
                        replyHandler.handle(AsyncResult.success(msg));
                    }
                }

                @Override
                public void handleError(Throwable err) {
                    if (registered.compareAndSet(true, false)) {
                        this.cancelTimeout();
                        EventBusClient.this.unregister(this, false);
                        replyHandler.handle(AsyncResult.failure(err));
                    }
                }
            };
            messageHandler.setTimeout((ScheduledFuture<?>)this.group.next().schedule(new Runnable(){

                @Override
                public void run() {
                    messageHandler.handleError(new TimeoutException());
                }
            }, options.getSendTimeout(), TimeUnit.MILLISECONDS));
            this.register(messageHandler, null, false);
        } else {
            replyAddr = null;
        }
        this.send("send", address, message, options.getHeaders(), replyAddr);
        return this;
    }

    public EventBusClient publish(String address, Object message) {
        this.send("publish", address, message, this.defaultOptions.getHeaders(), null);
        return this;
    }

    public EventBusClient publish(String address, Object message, DeliveryOptions options) {
        this.send("publish", address, message, options == null ? null : options.getHeaders(), null);
        return this;
    }

    public <T> MessageConsumer<T> consumer(String address, Handler<Message<T>> handler) {
        MessageConsumer<T> consumer = new MessageConsumer<T>(this, address, handler);
        this.register(consumer.handler, this.defaultOptions == null ? null : this.defaultOptions.getHeaders(), true);
        return consumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void register(MessageHandler<?> handler, Map<String, String> headers, boolean atServer) {
        String address = handler.address();
        ConcurrentMap<String, HandlerList> concurrentMap = this.consumerMap;
        synchronized (concurrentMap) {
            List<MessageHandler> handlers;
            HandlerList consumers = (HandlerList)this.consumerMap.get(address);
            if (consumers == null) {
                handlers = Collections.singletonList(handler);
                if (atServer) {
                    if (this.connected) {
                        this.logger.info("Registering address: " + address);
                        this.send("register", address, null, headers, null);
                    } else {
                        this.initializeTransport();
                        this.connectTransport();
                    }
                }
            } else {
                ArrayList tmp = new ArrayList(consumers.handlers);
                tmp.add(handler);
                handlers = new ArrayList<MessageHandler>(tmp);
            }
            this.consumerMap.put(address, new HandlerList(handlers, atServer));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void unregister(MessageHandler<?> handler, boolean atServer) {
        String address = handler.address();
        ConcurrentMap<String, HandlerList> concurrentMap = this.consumerMap;
        synchronized (concurrentMap) {
            HandlerList consumers = (HandlerList)this.consumerMap.get(address);
            if (consumers == null) {
                return;
            }
            if (!consumers.handlers.contains(handler)) {
                return;
            }
            ArrayList handlers = new ArrayList(consumers.handlers);
            handlers.remove(handler);
            if (atServer && handlers.isEmpty()) {
                this.consumerMap.remove(address);
                HashMap<String, String> obj = new HashMap<String, String>();
                obj.put("type", "unregister");
                obj.put("address", address);
                String msg = this.codec.encode(obj);
                this.send(msg);
            } else {
                this.consumerMap.put(address, new HandlerList(new ArrayList<MessageHandler>(handlers), atServer));
            }
        }
    }

    public EventBusClient connectedHandler(Handler<Handler<Void>> connectedHandler) {
        this.connectedHandler = connectedHandler;
        return this;
    }

    public EventBusClient exceptionHandler(Handler<Throwable> exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
        this.transport.setExceptionHandler(exceptionHandler);
        return this;
    }

    public synchronized EventBusClient closeHandler(Handler<Void> closeHandler) {
        this.closeHandler = closeHandler;
        return this;
    }

    private void handleError(String message, Throwable t) {
        this.logger.error(message, t);
        Handler<Throwable> handler = this.exceptionHandler;
        if (handler != null) {
            try {
                handler.handle(t);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void send(String type, String address, Object body, Map<String, String> headers, String replyAddress) {
        HashMap<String, Object> obj = new HashMap<String, Object>();
        obj.put("type", type);
        obj.put("address", address);
        if (replyAddress != null) {
            obj.put("replyAddress", replyAddress);
        }
        if (headers != null) {
            obj.put("headers", headers);
        }
        if (body != null) {
            obj.put("body", body);
        }
        String msg = this.codec.encode(obj);
        this.send(msg);
    }

    private void send(final String message) {
        this.execute(new Handler<Transport>(){

            @Override
            public void handle(Transport event) {
                if (message.length() > MESSAGE_PRINT_LIMIT) {
                    EventBusClient.this.logger.info("Sending message with " + message.length() + " chars.");
                } else {
                    EventBusClient.this.logger.info("Sending message: " + message);
                }
                EventBusClient.this.transport.send(message);
            }
        });
    }

    private class HandlerList {
        private final List<MessageHandler> handlers;
        private final boolean reregisterAtServer;

        HandlerList(List<MessageHandler> handlers, boolean reregisterAtServer) {
            this.handlers = handlers;
            this.reregisterAtServer = reregisterAtServer;
        }

        void send(Message message) {
            for (MessageHandler handler : this.handlers) {
                try {
                    handler.handleMessage(message);
                }
                catch (Throwable t) {
                    EventBusClient.this.handleError("Exception in message handler.", t);
                }
            }
        }

        void fail(Throwable cause) {
            for (MessageHandler handler : this.handlers) {
                try {
                    handler.handleError(cause);
                }
                catch (Throwable t) {
                    EventBusClient.this.handleError("Exception in message error handler.", t);
                }
            }
        }
    }
}

