/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.eventbusclient;

import io.vertx.eventbusclient.ProxyType;
import java.util.Arrays;
import java.util.Objects;

public class EventBusClientOptions {
    public static final String DEFAULT_HOST = "localhost";
    public static final int DEFAULT_PORT = -1;
    public static final int DEFAULT_CONNECT_TIMEOUT = 60000;
    public static final int DEFAULT_PING_INTERVAL = 5000;
    public static final boolean DEFAULT_SSL = false;
    public static final int DEFAULT_IDLE_TIMEOUT = 0;
    public static final boolean DEFAULT_VERIFY_HOST = true;
    public static final boolean DEFAULT_TRUST_ALL = false;
    public static final boolean DEFAULT_AUTO_RECONNECT = true;
    public static final int DEFAULT_AUTO_RECONNECT_INTERVAL = 3000;
    public static final int DEFAULT_MAX_AUTO_RECONNECT_TRIES = 0;
    public static final String DEFAULT_WEBSOCKET_PATH = "/eventbus/websocket";
    public static final int DEFAULT_MAX_WEBSOCKET_FRAME_SIZE = 65536;
    private String host;
    private int port;
    private boolean ssl;
    private String trustStorePath;
    private String trustStorePassword;
    private String trustStoreType = "jks";
    private boolean verifyHost;
    private boolean trustAll;
    private int idleTimeout;
    private int pingInterval;
    private int connectTimeout;
    private boolean autoReconnect;
    private int autoReconnectInterval;
    private int maxAutoReconnectTries;
    private String proxyHost;
    private int proxyPort;
    private String proxyUsername;
    private String proxyPassword;
    private ProxyType proxyType;
    private String webSocketPath;
    private int maxWebSocketFrameSize;

    public EventBusClientOptions() {
        this.host = DEFAULT_HOST;
        this.port = -1;
        this.ssl = false;
        this.idleTimeout = 0;
        this.connectTimeout = 60000;
        this.pingInterval = 5000;
        this.verifyHost = true;
        this.trustAll = false;
        this.autoReconnect = true;
        this.autoReconnectInterval = 3000;
        this.maxAutoReconnectTries = 0;
        this.webSocketPath = DEFAULT_WEBSOCKET_PATH;
        this.maxWebSocketFrameSize = 65536;
    }

    public EventBusClientOptions(EventBusClientOptions options) {
        this.host = options.host;
        this.port = options.port;
        this.ssl = options.ssl;
        this.trustStorePath = options.trustStorePath;
        this.trustStorePassword = options.trustStorePassword;
        this.trustStoreType = options.trustStoreType;
        this.verifyHost = options.verifyHost;
        this.trustAll = options.trustAll;
        this.idleTimeout = options.idleTimeout;
        this.pingInterval = options.pingInterval;
        this.connectTimeout = options.connectTimeout;
        this.autoReconnect = options.autoReconnect;
        this.autoReconnectInterval = options.autoReconnectInterval;
        this.maxAutoReconnectTries = options.maxAutoReconnectTries;
        this.proxyHost = options.proxyHost;
        this.proxyPort = options.proxyPort;
        this.proxyType = options.proxyType;
        this.proxyPassword = options.proxyPassword;
        this.proxyUsername = options.proxyUsername;
        this.webSocketPath = options.webSocketPath;
        this.maxWebSocketFrameSize = options.maxWebSocketFrameSize;
    }

    public EventBusClientOptions setHost(String host) {
        this.host = host;
        return this;
    }

    public String getHost() {
        return this.host;
    }

    public EventBusClientOptions setPort(int port) {
        this.port = port;
        return this;
    }

    public int getPort() {
        return this.port;
    }

    public EventBusClientOptions setSsl(boolean ssl) {
        this.ssl = ssl;
        return this;
    }

    public boolean isSsl() {
        return this.ssl;
    }

    public EventBusClientOptions setIdleTimeout(int idleTimeout) {
        if (idleTimeout < 0) {
            throw new IllegalArgumentException("idleTimeout must be >= 0");
        }
        this.idleTimeout = idleTimeout;
        return this;
    }

    public int getIdleTimeout() {
        return this.idleTimeout;
    }

    public EventBusClientOptions setConnectTimeout(int connectTimeout) {
        if (connectTimeout < 0) {
            throw new IllegalArgumentException("connectTimeout must be >= 0");
        }
        this.connectTimeout = connectTimeout;
        return this;
    }

    public int getConnectTimeout() {
        return this.connectTimeout;
    }

    public EventBusClientOptions setPingInterval(int pingInterval) {
        if (pingInterval <= 0) {
            throw new IllegalArgumentException("pingInterval must be > 0");
        }
        this.pingInterval = pingInterval;
        return this;
    }

    public int getPingInterval() {
        return this.pingInterval;
    }

    public EventBusClientOptions setVerifyHost(boolean verifyHost) {
        this.verifyHost = verifyHost;
        return this;
    }

    public boolean isVerifyHost() {
        return this.verifyHost;
    }

    public EventBusClientOptions setTrustAll(boolean trustAll) {
        this.trustAll = trustAll;
        return this;
    }

    public boolean isTrustAll() {
        return this.trustAll;
    }

    public boolean isAutoReconnect() {
        return this.autoReconnect;
    }

    public EventBusClientOptions setAutoReconnect(boolean autoReconnect) {
        this.autoReconnect = autoReconnect;
        return this;
    }

    public int getAutoReconnectInterval() {
        return this.autoReconnectInterval;
    }

    public EventBusClientOptions setAutoReconnectInterval(int autoReconnectInterval) {
        this.autoReconnectInterval = autoReconnectInterval;
        return this;
    }

    public int getMaxAutoReconnectTries() {
        return this.maxAutoReconnectTries;
    }

    public EventBusClientOptions setMaxAutoReconnectTries(int maxAutoReconnectTries) {
        this.maxAutoReconnectTries = maxAutoReconnectTries;
        return this;
    }

    public String getTrustStorePath() {
        return this.trustStorePath;
    }

    public EventBusClientOptions setTrustStorePath(String trustStorePath) {
        this.trustStorePath = trustStorePath;
        return this;
    }

    public String getTrustStorePassword() {
        return this.trustStorePassword;
    }

    public EventBusClientOptions setTrustStorePassword(String trustStorePassword) {
        this.trustStorePassword = trustStorePassword;
        return this;
    }

    public String getTrustStoreType() {
        return this.trustStoreType;
    }

    public EventBusClientOptions setTrustStoreType(String trustStoreType) {
        if (!Arrays.asList("jks", "pfx", "pem", null).contains(trustStoreType)) {
            throw new IllegalArgumentException("Invalid trust store type it must be one of jks (Java), pfx (PKCS12) or pem (PKCS8)");
        }
        this.trustStoreType = trustStoreType;
        return this;
    }

    public EventBusClientOptions setWebSocketPath(String webSocketPath) {
        this.webSocketPath = webSocketPath;
        return this;
    }

    public String getWebSocketPath() {
        return this.webSocketPath;
    }

    public int getMaxWebSocketFrameSize() {
        return this.maxWebSocketFrameSize;
    }

    public EventBusClientOptions setMaxWebSocketFrameSize(int websocketMaxWebsocketFrameSize) {
        this.maxWebSocketFrameSize = websocketMaxWebsocketFrameSize;
        return this;
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public EventBusClientOptions setProxyHost(String proxyHost) {
        Objects.requireNonNull(proxyHost, "Proxy host may not be null");
        this.proxyHost = proxyHost;
        return this;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    public EventBusClientOptions setProxyPort(int proxyPort) {
        if (proxyPort < 0 || proxyPort > 65535) {
            throw new IllegalArgumentException("Invalid proxy port " + proxyPort);
        }
        this.proxyPort = proxyPort;
        return this;
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public EventBusClientOptions setProxyUsername(String username) {
        this.proxyUsername = username;
        return this;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public EventBusClientOptions setProxyPassword(String password) {
        this.proxyPassword = password;
        return this;
    }

    public ProxyType getProxyType() {
        return this.proxyType;
    }

    public EventBusClientOptions setProxyType(ProxyType proxyType) {
        Objects.requireNonNull(proxyType, "Proxy proxyType may not be null");
        this.proxyType = proxyType;
        return this;
    }
}

