/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.eventbusclient;

import io.vertx.eventbusclient.AsyncResult;
import io.vertx.eventbusclient.DeliveryOptions;
import io.vertx.eventbusclient.EventBusClient;
import io.vertx.eventbusclient.Handler;
import java.util.Collections;
import java.util.Map;

public class Message<T> {
    private final EventBusClient client;
    private final String address;
    private final Map<String, String> headers;
    private final T body;
    private final String replyAddress;

    public Message(EventBusClient client, String address, Map<String, String> headers, T body, String replyAddress) {
        this.client = client;
        this.address = address;
        this.headers = headers == null ? Collections.emptyMap() : headers;
        this.body = body;
        this.replyAddress = replyAddress;
    }

    public String address() {
        return this.address;
    }

    public Map<String, String> headers() {
        return this.headers;
    }

    public T body() {
        return this.body;
    }

    public String replyAddress() {
        return this.replyAddress;
    }

    public void reply(Object body) {
        if (this.replyAddress == null) {
            throw new IllegalStateException();
        }
        this.client.send(this.replyAddress, body);
    }

    public void reply(Object body, DeliveryOptions options) {
        if (this.replyAddress == null) {
            throw new IllegalStateException();
        }
        this.client.send(this.replyAddress, body, options);
    }

    public <R> void replyAndRequest(Object body, Handler<AsyncResult<Message<R>>> handler) {
        if (this.replyAddress == null) {
            throw new IllegalStateException();
        }
        this.client.request(this.replyAddress, body, handler);
    }

    public <R> void replyAndRequest(Object body, DeliveryOptions options, Handler<AsyncResult<Message<R>>> handler) {
        if (this.replyAddress == null) {
            throw new IllegalStateException();
        }
        this.client.request(this.replyAddress, body, options, handler);
    }
}

