/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.eventbusclient;

import io.vertx.eventbusclient.EventBusClient;
import io.vertx.eventbusclient.Handler;
import io.vertx.eventbusclient.Message;
import io.vertx.eventbusclient.MessageHandler;
import java.util.concurrent.atomic.AtomicBoolean;

public class MessageConsumer<T> {
    private EventBusClient client;
    final String address;
    final MessageHandler<T> handler;
    private final AtomicBoolean registered = new AtomicBoolean(true);

    MessageConsumer(EventBusClient client, final String address, final Handler<Message<T>> handler) {
        this.client = client;
        this.address = address;
        this.handler = new MessageHandler<T>(){

            @Override
            public String address() {
                return address;
            }

            @Override
            public void handleMessage(Message<T> msg) {
                handler.handle(msg);
            }
        };
    }

    public void unregister() {
        if (this.registered.compareAndSet(true, false)) {
            this.client.unregister(this.handler, true);
        }
    }
}

