/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.eventbusclient.json;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.vertx.eventbusclient.json.JsonCodec;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;

public class JacksonCodec
extends JsonCodec {
    private final ObjectMapper mapper = new ObjectMapper();

    @Override
    public String encode(Object obj) {
        try {
            return this.mapper.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            throw new UndeclaredThrowableException(e);
        }
    }

    @Override
    public <T> T decode(String json, Class<T> type) {
        try {
            return (T)this.mapper.readValue(json, type);
        }
        catch (IOException e) {
            throw new UndeclaredThrowableException(e);
        }
    }
}

