/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.eventbusclient.transport;

import io.netty.channel.Channel;
import io.netty.channel.ChannelDuplexHandler;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerAdapter;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.proxy.HttpProxyHandler;
import io.netty.handler.proxy.ProxyConnectionEvent;
import io.netty.handler.proxy.ProxyHandler;
import io.netty.handler.proxy.Socks4ProxyHandler;
import io.netty.handler.proxy.Socks5ProxyHandler;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SslContextBuilder;
import io.netty.handler.ssl.SslHandler;
import io.netty.handler.ssl.util.InsecureTrustManagerFactory;
import io.netty.handler.timeout.IdleStateEvent;
import io.netty.handler.timeout.IdleStateHandler;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import io.vertx.eventbusclient.ClientException;
import io.vertx.eventbusclient.EventBusClient;
import io.vertx.eventbusclient.EventBusClientOptions;
import io.vertx.eventbusclient.Handler;
import io.vertx.eventbusclient.ProxyType;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.security.KeyStore;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.TrustManagerFactory;

public abstract class Transport
extends ChannelInitializer {
    final EventBusClientOptions options;
    private final InternalLogger logger;
    private final SslContext sslContext;
    Handler<Void> connectedHandler;
    Handler<String> messageHandler;
    Handler<Void> closeHandler;
    private Handler<Throwable> exceptionHandler;

    Transport(EventBusClientOptions options) {
        SslContext sslContext;
        try {
            sslContext = Transport.build(options);
        }
        catch (Exception e) {
            throw new ClientException(e);
        }
        this.options = options;
        this.logger = InternalLoggerFactory.getInstance(Transport.class);
        this.sslContext = sslContext;
    }

    private static SslContext build(EventBusClientOptions options) throws Exception {
        SslContextBuilder builder = SslContextBuilder.forClient();
        if (options.isTrustAll()) {
            builder.trustManager(InsecureTrustManagerFactory.INSTANCE);
        } else if (options.getTrustStorePath() != null) {
            String storePath = options.getTrustStorePath();
            InputStream storeIS = null;
            if (storePath != null) {
                File f = new File(storePath);
                storeIS = f.exists() && f.isFile() ? new FileInputStream(f) : Thread.currentThread().getContextClassLoader().getResourceAsStream(storePath);
            }
            if (storeIS == null) {
                throw new IllegalArgumentException("Store file not found:" + storePath);
            }
            if ("pem".equals(options.getTrustStoreType())) {
                builder.trustManager(storeIS);
            } else {
                KeyStore keyStore = "jks".equals(options.getTrustStoreType()) ? KeyStore.getInstance("jks") : KeyStore.getInstance("pkcs12");
                if (options.getTrustStorePassword() != null) {
                    keyStore.load(storeIS, options.getTrustStorePassword().toCharArray());
                } else {
                    keyStore.load(storeIS, null);
                }
                TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
                trustManagerFactory.init(keyStore);
                builder.trustManager(trustManagerFactory);
            }
        }
        return builder.build();
    }

    protected void initChannel(final Channel channel) throws Exception {
        final ChannelPipeline pipeline = channel.pipeline();
        channel.config().setConnectTimeoutMillis(this.options.getConnectTimeout());
        if (this.options.getProxyHost() == null && !this.options.isSsl()) {
            pipeline.addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

                public void channelActive(ChannelHandlerContext ctx) throws Exception {
                    super.channelActive(ctx);
                    Transport.this.handshakeCompleteHandler(channel);
                }
            }});
        }
        if (this.options.getProxyHost() != null) {
            HttpProxyHandler proxyHandler;
            String proxyHost = this.options.getProxyHost();
            int proxyPort = this.options.getProxyPort();
            String proxyUsername = this.options.getProxyUsername();
            String proxyPassword = this.options.getProxyPassword();
            ProxyType proxyType = this.options.getProxyType();
            InetSocketAddress proxyAddress = new InetSocketAddress(proxyHost, proxyPort);
            switch (proxyType) {
                default: {
                    proxyHandler = proxyUsername != null && proxyPassword != null ? new HttpProxyHandler((SocketAddress)proxyAddress, proxyUsername, proxyPassword) : new HttpProxyHandler((SocketAddress)proxyAddress);
                    break;
                }
                case SOCKS4: {
                    proxyHandler = proxyUsername != null ? new Socks4ProxyHandler((SocketAddress)proxyAddress, proxyUsername) : new Socks4ProxyHandler((SocketAddress)proxyAddress);
                    break;
                }
                case SOCKS5: {
                    proxyHandler = proxyUsername != null && proxyPassword != null ? new Socks5ProxyHandler((SocketAddress)proxyAddress, proxyUsername, proxyPassword) : new Socks5ProxyHandler((SocketAddress)proxyAddress);
                }
            }
            pipeline.addLast("proxyHandler", (ChannelHandler)proxyHandler);
            pipeline.addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter((ProxyHandler)proxyHandler, channel){
                final /* synthetic */ ProxyHandler val$proxyHandler;
                final /* synthetic */ Channel val$channel;
                {
                    this.val$proxyHandler = proxyHandler;
                    this.val$channel = channel;
                }

                public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
                    if (evt instanceof ProxyConnectionEvent) {
                        pipeline.remove((ChannelHandler)this.val$proxyHandler);
                        pipeline.remove((ChannelHandler)this);
                        if (!Transport.this.options.isSsl()) {
                            Transport.this.handshakeCompleteHandler(this.val$channel);
                        }
                    }
                    ctx.fireUserEventTriggered(evt);
                }
            }});
            pipeline.addLast("proxyExceptionHandler", (ChannelHandler)new ChannelHandlerAdapter(){

                public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                    Transport.this.handleError("A proxy exception occured.", cause);
                }
            });
        }
        if (this.options.isSsl()) {
            SSLParameters sslParams = new SSLParameters();
            if (this.options.isVerifyHost()) {
                sslParams.setEndpointIdentificationAlgorithm("HTTPS");
            }
            SSLEngine sslEngine = this.sslContext.newEngine(channel.alloc(), this.options.getHost(), this.options.getPort());
            sslEngine.setUseClientMode(true);
            sslEngine.setSSLParameters(sslParams);
            SslHandler sslHandler = new SslHandler(sslEngine, false);
            sslHandler.handshakeFuture().addListener((GenericFutureListener)new GenericFutureListener<Future<Channel>>(){

                public void operationComplete(Future<Channel> future) {
                    if (future.isSuccess()) {
                        Transport.this.handshakeCompleteHandler((Channel)future.getNow());
                    }
                }
            });
            pipeline.addLast("sslHandler", (ChannelHandler)sslHandler);
            pipeline.addLast("sslExceptionHandler", (ChannelHandler)new ChannelHandlerAdapter(){

                public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
                    Transport.this.handleError("A TLS exception occured.", cause);
                }
            });
        }
        if (this.options.getIdleTimeout() > 0) {
            pipeline.addLast("idleStateHandler", (ChannelHandler)new IdleStateHandler(0L, 0L, (long)this.options.getIdleTimeout(), TimeUnit.MILLISECONDS));
            pipeline.addLast("idleEventHandler", (ChannelHandler)new ChannelDuplexHandler(){

                public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
                    if (evt instanceof IdleStateEvent) {
                        ctx.close();
                    }
                }
            });
        }
    }

    public void connectedHandler(Handler<Void> handler) {
        this.connectedHandler = handler;
    }

    public void messageHandler(Handler<String> handler) {
        this.messageHandler = handler;
    }

    public void closeHandler(Handler<Void> handler) {
        this.closeHandler = handler;
    }

    public void setExceptionHandler(Handler<Throwable> handler) {
        this.exceptionHandler = handler;
    }

    protected void handleError(String message, Throwable t) {
        this.logger.error(message, t);
        Handler<Throwable> handler = this.exceptionHandler;
        if (handler != null) {
            try {
                handler.handle(t);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    void addSendErrorHandler(final ChannelHandlerContext handlerCtx, final String message, ChannelFuture future) {
        future.addListener((GenericFutureListener)new GenericFutureListener<Future<Void>>(){

            public void operationComplete(Future<Void> future) {
                if (!future.isSuccess() && handlerCtx.channel().isOpen() && !(future.cause() instanceof SSLException)) {
                    if (message.length() > EventBusClient.MESSAGE_PRINT_LIMIT) {
                        Transport.this.handleError("Could not send message with " + message.length() + " chars.", future.cause());
                    } else {
                        Transport.this.handleError("Could not send message: " + message, future.cause());
                    }
                }
            }
        });
    }

    abstract void handshakeCompleteHandler(Channel var1);

    public abstract void send(String var1);
}

