/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.eventbusclient.transport;

import io.netty.buffer.ByteBuf;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.http.DefaultHttpHeaders;
import io.netty.handler.codec.http.HttpClientCodec;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpObjectAggregator;
import io.netty.handler.codec.http.websocketx.BinaryWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketClientHandshakerFactory;
import io.netty.handler.codec.http.websocketx.WebSocketClientProtocolHandler;
import io.netty.handler.codec.http.websocketx.WebSocketVersion;
import io.vertx.eventbusclient.EventBusClientOptions;
import io.vertx.eventbusclient.transport.Transport;
import java.net.URI;
import java.nio.charset.StandardCharsets;

public class WebSocketTransport
extends Transport {
    private ChannelHandlerContext handlerCtx;
    private boolean handshakeComplete = false;
    private boolean reading;
    private boolean flush;

    public WebSocketTransport(EventBusClientOptions options) {
        super(options);
    }

    @Override
    protected void initChannel(Channel channel) throws Exception {
        super.initChannel(channel);
        StringBuilder url = new StringBuilder();
        url.append("ws");
        if (this.options.isSsl()) {
            url.append("s");
        }
        url.append("://").append(this.options.getHost()).append(this.options.getWebSocketPath());
        WebSocketClientHandshaker handshaker = WebSocketClientHandshakerFactory.newHandshaker((URI)new URI(url.toString()), (WebSocketVersion)WebSocketVersion.V13, null, (boolean)false, (HttpHeaders)new DefaultHttpHeaders(), (int)this.options.getMaxWebSocketFrameSize());
        WebSocketClientProtocolHandler handler = new WebSocketClientProtocolHandler(handshaker);
        ChannelPipeline pipeline = channel.pipeline();
        pipeline.addLast(new ChannelHandler[]{new HttpClientCodec()});
        pipeline.addLast(new ChannelHandler[]{new HttpObjectAggregator(8192)});
        pipeline.addLast(new ChannelHandler[]{handler});
        pipeline.addLast(new ChannelHandler[]{new ChannelInboundHandlerAdapter(){

            public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
                if (evt == WebSocketClientProtocolHandler.ClientHandshakeStateEvent.HANDSHAKE_COMPLETE) {
                    WebSocketTransport.this.handlerCtx = ctx;
                    WebSocketTransport.this.handshakeComplete = true;
                    WebSocketTransport.this.connectedHandler.handle(null);
                }
            }

            public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
                WebSocketTransport.this.reading = true;
                if (msg instanceof BinaryWebSocketFrame) {
                    BinaryWebSocketFrame frame = (BinaryWebSocketFrame)msg;
                    String json = frame.content().toString(StandardCharsets.UTF_8);
                    WebSocketTransport.this.messageHandler.handle(json);
                } else {
                    System.out.println("Unhandled " + msg);
                }
            }

            public void channelReadComplete(ChannelHandlerContext ctx) throws Exception {
                super.channelReadComplete(ctx);
                WebSocketTransport.this.reading = false;
                if (WebSocketTransport.this.flush) {
                    WebSocketTransport.this.flush = false;
                    ctx.flush();
                }
            }

            public void channelInactive(ChannelHandlerContext ctx) throws Exception {
                WebSocketTransport.this.handlerCtx = null;
                if (WebSocketTransport.this.handshakeComplete) {
                    WebSocketTransport.this.closeHandler.handle(null);
                }
            }
        }});
    }

    @Override
    void handshakeCompleteHandler(Channel channel) {
    }

    @Override
    public void send(final String message) {
        if (this.handlerCtx.executor().inEventLoop()) {
            ByteBuf buff = this.handlerCtx.alloc().buffer();
            buff.writeCharSequence((CharSequence)message, StandardCharsets.UTF_8);
            BinaryWebSocketFrame frame = new BinaryWebSocketFrame(buff);
            if (this.reading) {
                this.flush = true;
                this.addSendErrorHandler(this.handlerCtx, message, this.handlerCtx.write((Object)frame));
            } else {
                this.addSendErrorHandler(this.handlerCtx, message, this.handlerCtx.writeAndFlush((Object)frame));
            }
        } else {
            this.handlerCtx.executor().execute(new Runnable(){

                @Override
                public void run() {
                    WebSocketTransport.this.send(message);
                }
            });
        }
    }
}

