/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.grpc.common;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.Parser;
import com.google.protobuf.util.JsonFormat;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.DecodeException;
import io.vertx.core.json.Json;
import io.vertx.core.json.JsonObject;
import io.vertx.grpc.common.CodecException;
import io.vertx.grpc.common.GrpcMessage;
import io.vertx.grpc.common.WireFormat;
import java.nio.charset.StandardCharsets;
import java.util.function.Supplier;

@VertxGen
public interface GrpcMessageDecoder<T> {
    public static final GrpcMessageDecoder<Buffer> IDENTITY = new GrpcMessageDecoder<Buffer>(){

        @Override
        public Buffer decode(GrpcMessage msg) throws CodecException {
            return msg.payload();
        }

        @Override
        public WireFormat format() {
            return WireFormat.PROTOBUF;
        }
    };
    public static final GrpcMessageDecoder<JsonObject> JSON_OBJECT = new GrpcMessageDecoder<JsonObject>(){

        @Override
        public JsonObject decode(GrpcMessage msg) throws CodecException {
            Object val = JSON_VALUE.decode(msg);
            if (val instanceof JsonObject) {
                return (JsonObject)val;
            }
            throw new CodecException("Was expecting an instance of JsonObject instead of " + val.getClass().getName());
        }

        @Override
        public WireFormat format() {
            return WireFormat.JSON;
        }
    };
    public static final GrpcMessageDecoder<Object> JSON_VALUE = new GrpcMessageDecoder<Object>(){

        @Override
        public Object decode(GrpcMessage msg) throws CodecException {
            if (!WireFormat.JSON.equals((Object)msg.format())) {
                throw new CodecException("Was expecting a json message");
            }
            try {
                return Json.decodeValue((Buffer)msg.payload());
            }
            catch (DecodeException e) {
                throw new CodecException(e);
            }
        }

        @Override
        public WireFormat format() {
            return WireFormat.JSON;
        }
    };

    @GenIgnore
    public static <T> GrpcMessageDecoder<T> decoder(final Parser<T> parser) {
        return new GrpcMessageDecoder<T>(){

            @Override
            public T decode(GrpcMessage msg) throws CodecException {
                try {
                    return parser.parseFrom(msg.payload().getBytes());
                }
                catch (InvalidProtocolBufferException e) {
                    throw new CodecException(e);
                }
            }

            @Override
            public WireFormat format() {
                return WireFormat.PROTOBUF;
            }
        };
    }

    @GenIgnore
    public static <T> GrpcMessageDecoder<T> json(final Supplier<Message.Builder> builder) {
        return new GrpcMessageDecoder<T>(){

            @Override
            public T decode(GrpcMessage msg) throws CodecException {
                try {
                    Message.Builder builderInstance = (Message.Builder)builder.get();
                    JsonFormat.parser().merge(msg.payload().toString(StandardCharsets.UTF_8), builderInstance);
                    return builderInstance.build();
                }
                catch (InvalidProtocolBufferException e) {
                    throw new CodecException(e);
                }
            }

            @Override
            public WireFormat format() {
                return WireFormat.JSON;
            }
        };
    }

    public static <T> GrpcMessageDecoder<T> json(final Class<T> clazz) {
        return new GrpcMessageDecoder<T>(){

            @Override
            public T decode(GrpcMessage msg) throws CodecException {
                if (!WireFormat.JSON.equals((Object)msg.format())) {
                    throw new CodecException("Was expecting a json message");
                }
                try {
                    return Json.decodeValue((Buffer)msg.payload(), (Class)clazz);
                }
                catch (DecodeException e) {
                    throw new CodecException(e);
                }
            }

            @Override
            public WireFormat format() {
                return WireFormat.JSON;
            }
        };
    }

    public T decode(GrpcMessage var1) throws CodecException;

    public WireFormat format();
}

