/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.grpc.common;

import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.MessageLite;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.util.JsonFormat;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.Json;
import io.vertx.core.json.JsonObject;
import io.vertx.grpc.common.CodecException;
import io.vertx.grpc.common.GrpcMessage;
import io.vertx.grpc.common.WireFormat;

@VertxGen
public interface GrpcMessageEncoder<T> {
    public static final GrpcMessageEncoder<Buffer> IDENTITY = new GrpcMessageEncoder<Buffer>(){

        @Override
        public GrpcMessage encode(Buffer payload) {
            return GrpcMessage.message("identity", WireFormat.PROTOBUF, payload);
        }

        @Override
        public WireFormat format() {
            return WireFormat.PROTOBUF;
        }
    };
    public static final GrpcMessageEncoder<JsonObject> JSON_OBJECT = new GrpcMessageEncoder<JsonObject>(){

        @Override
        public GrpcMessage encode(JsonObject msg) {
            return GrpcMessage.message("identity", WireFormat.JSON, msg == null ? Buffer.buffer((String)"null") : msg.toBuffer());
        }

        @Override
        public WireFormat format() {
            return WireFormat.JSON;
        }
    };

    @GenIgnore
    public static <T extends MessageLite> GrpcMessageEncoder<T> encoder() {
        return new GrpcMessageEncoder<T>(){

            @Override
            public GrpcMessage encode(T msg) {
                byte[] bytes = msg.toByteArray();
                return GrpcMessage.message("identity", Buffer.buffer((byte[])bytes));
            }

            @Override
            public WireFormat format() {
                return WireFormat.PROTOBUF;
            }
        };
    }

    public static <T> GrpcMessageEncoder<T> json() {
        return new GrpcMessageEncoder<T>(){

            @Override
            public GrpcMessage encode(T msg) {
                if (msg instanceof MessageOrBuilder) {
                    MessageOrBuilder mob = (MessageOrBuilder)msg;
                    try {
                        String res = JsonFormat.printer().print(mob);
                        return GrpcMessage.message("identity", WireFormat.JSON, Buffer.buffer((String)res));
                    }
                    catch (InvalidProtocolBufferException e) {
                        throw new CodecException(e);
                    }
                }
                return GrpcMessage.message("identity", WireFormat.JSON, Json.encodeToBuffer(msg));
            }

            @Override
            public WireFormat format() {
                return WireFormat.JSON;
            }
        };
    }

    public GrpcMessage encode(T var1);

    public WireFormat format();
}

