/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.grpc.common.impl;

import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.MultiMap;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.http.StreamResetException;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.streams.WriteStream;
import io.vertx.grpc.common.CodecException;
import io.vertx.grpc.common.GrpcError;
import io.vertx.grpc.common.GrpcMessage;
import io.vertx.grpc.common.GrpcMessageEncoder;
import io.vertx.grpc.common.GrpcWriteStream;
import io.vertx.grpc.common.WireFormat;
import io.vertx.grpc.common.impl.Utils;
import java.util.Objects;

public abstract class GrpcWriteStreamBase<S extends GrpcWriteStreamBase<S, T>, T>
implements GrpcWriteStream<T> {
    protected final ContextInternal context;
    private final GrpcMessageEncoder<T> messageEncoder;
    private final WriteStream<Buffer> writeStream;
    protected String mediaType;
    protected String encoding;
    protected WireFormat format;
    private boolean headersSent;
    private boolean trailersSent;
    private GrpcError error;
    private MultiMap headers;
    private MultiMap trailers;
    private Handler<Throwable> exceptionHandler;
    private Handler<GrpcError> errorHandler;

    public GrpcWriteStreamBase(ContextInternal context, String mediaType, WriteStream<Buffer> writeStream, GrpcMessageEncoder<T> messageEncoder) {
        this.context = context;
        this.writeStream = writeStream;
        this.messageEncoder = messageEncoder;
        this.mediaType = mediaType;
    }

    public void init() {
        this.writeStream.exceptionHandler(err -> {
            if (err instanceof StreamResetException) {
                StreamResetException reset = (StreamResetException)err;
                GrpcError error = GrpcError.mapHttp2ErrorCode(reset.getCode());
                this.handleError(error);
            } else {
                this.handleException((Throwable)err);
            }
        });
    }

    public S errorHandler(Handler<GrpcError> handler) {
        this.errorHandler = handler;
        return (S)this;
    }

    public void handleError(GrpcError error) {
        if (this.error == null) {
            this.error = error;
            Handler<GrpcError> handler = this.errorHandler;
            if (handler != null) {
                handler.handle((Object)error);
            }
        }
    }

    private void handleException(Throwable err) {
        Handler<Throwable> handler = this.exceptionHandler;
        if (handler != null) {
            handler.handle((Object)err);
        }
    }

    public final S encoding(String encoding) {
        if (this.headersSent) {
            throw new IllegalStateException("Cannot set encoding when headers have been sent");
        }
        this.encoding = Objects.requireNonNull(encoding);
        return (S)this;
    }

    public final S format(WireFormat format) {
        if (this.headersSent) {
            throw new IllegalStateException("Cannot set format when headers have been sent");
        }
        this.format = Objects.requireNonNull(format);
        return (S)this;
    }

    public final ContextInternal context() {
        return this.context;
    }

    public boolean isHeadersSent() {
        return this.headersSent;
    }

    public boolean isTrailersSent() {
        return this.trailersSent;
    }

    public boolean isCancelled() {
        return this.error == GrpcError.CANCELLED;
    }

    @Override
    public final MultiMap headers() {
        if (this.headersSent) {
            throw new IllegalStateException("Headers already sent");
        }
        if (this.headers == null) {
            this.headers = MultiMap.caseInsensitiveMultiMap();
        }
        return this.headers;
    }

    public final MultiMap trailers() {
        if (this.trailersSent) {
            throw new IllegalStateException("Trailers already sent");
        }
        if (this.trailers == null) {
            this.trailers = MultiMap.caseInsensitiveMultiMap();
        }
        return this.trailers;
    }

    public final boolean writeQueueFull() {
        return this.writeStream.writeQueueFull();
    }

    public final S drainHandler(Handler<Void> handler) {
        this.writeStream.drainHandler(handler);
        return (S)this;
    }

    public final S exceptionHandler(Handler<Throwable> handler) {
        this.exceptionHandler = handler;
        return (S)this;
    }

    public S setWriteQueueMaxSize(int maxSize) {
        this.writeStream.setWriteQueueMaxSize(maxSize);
        return (S)this;
    }

    public final Future<Void> write(T message) {
        return this.writeMessage(this.messageEncoder.encode(message));
    }

    public final Future<Void> end(T message) {
        return this.endMessage(this.messageEncoder.encode(message));
    }

    @Override
    public final Future<Void> writeMessage(GrpcMessage data) {
        return this.writeMessage(data, false);
    }

    @Override
    public final Future<Void> endMessage(GrpcMessage message) {
        return this.writeMessage(message, true);
    }

    public final Future<Void> end() {
        return this.writeMessage(null, true);
    }

    protected abstract void sendHeaders(String var1, MultiMap var2, boolean var3);

    protected abstract void sendTrailers(MultiMap var1);

    protected abstract Future<Void> sendMessage(Buffer var1, boolean var2);

    protected abstract Future<Void> sendEnd();

    private Future<Void> writeMessage(GrpcMessage message, boolean end) {
        Buffer payload;
        boolean compressed;
        if (this.error != null) {
            throw new IllegalStateException("The stream is failed: " + this.error);
        }
        if (this.trailersSent) {
            throw new IllegalStateException("The stream has been closed");
        }
        if (message == null && !end) {
            throw new IllegalStateException();
        }
        if (message != null) {
            if (this.format == null) {
                this.format = message.format();
            } else if (!this.format.equals((Object)message.format())) {
                return this.context.failedFuture("Message format does not match the response format");
            }
        }
        if (message != null) {
            if (this.encoding != null) {
                switch (this.encoding) {
                    case "gzip": {
                        compressed = true;
                        if (message.encoding().equals("identity")) {
                            try {
                                payload = Utils.GZIP_ENCODER.apply(message.payload());
                                break;
                            }
                            catch (CodecException e) {
                                return Future.failedFuture((Throwable)e);
                            }
                        }
                        if (!message.encoding().equals("gzip")) {
                            return Future.failedFuture((String)("Encoding " + message.encoding() + " is not supported"));
                        }
                        payload = message.payload();
                        break;
                    }
                    case "identity": {
                        compressed = false;
                        if (!message.encoding().equals("identity")) {
                            if (!message.encoding().equals("gzip")) {
                                return Future.failedFuture((String)("Encoding " + message.encoding() + " is not supported"));
                            }
                            try {
                                payload = Utils.GZIP_DECODER.apply(message.payload());
                                break;
                            }
                            catch (CodecException e) {
                                return Future.failedFuture((Throwable)e);
                            }
                        }
                        payload = message.payload();
                        break;
                    }
                    default: {
                        return Future.failedFuture((String)("Encoding " + this.encoding + " is not supported"));
                    }
                }
            } else {
                compressed = !message.encoding().equals("identity");
                payload = message.payload();
            }
        } else {
            compressed = false;
            payload = null;
        }
        if (!this.headersSent) {
            this.headersSent = true;
            Object contentType = this.mediaType;
            if (this.format != null) {
                switch (this.format) {
                    case JSON: {
                        contentType = this.mediaType + "+json";
                        break;
                    }
                }
            }
            this.sendHeaders((String)contentType, this.headers, end);
        }
        if (end) {
            if (!this.trailersSent) {
                this.trailersSent = true;
            }
            if (payload != null) {
                this.sendMessage(payload, compressed);
            }
            this.sendTrailers(this.trailers);
            return this.sendEnd();
        }
        return this.sendMessage(payload, compressed);
    }
}

