/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.grpc.common.impl;

import io.vertx.grpc.common.ServiceName;
import java.util.Objects;

public class ServiceNameImpl
implements ServiceName {
    private String name;
    private String packageName;
    private String fullyQualifiedName;

    public ServiceNameImpl(String packageName, String name) {
        this.name = name;
        this.packageName = packageName;
    }

    public ServiceNameImpl(String fullyQualifiedName) {
        this.fullyQualifiedName = fullyQualifiedName;
    }

    @Override
    public String name() {
        if (this.name == null) {
            int idx = this.fullyQualifiedName.lastIndexOf(46);
            this.name = this.fullyQualifiedName.substring(idx + 1);
        }
        return this.name;
    }

    @Override
    public String packageName() {
        if (this.packageName == null) {
            if (this.fullyQualifiedName == null) {
                return "";
            }
            int idx = this.fullyQualifiedName.lastIndexOf(46);
            this.packageName = idx < 0 ? "" : this.fullyQualifiedName.substring(0, idx);
        }
        return this.packageName;
    }

    @Override
    public String fullyQualifiedName() {
        if (this.fullyQualifiedName == null) {
            this.fullyQualifiedName = this.packageName == null || this.packageName.isEmpty() ? this.name : this.packageName + "." + this.name;
        }
        return this.fullyQualifiedName;
    }

    @Override
    public String pathOf(String method) {
        if (this.fullyQualifiedName != null) {
            return "/" + this.fullyQualifiedName + "/" + method;
        }
        if (this.packageName == null || this.packageName.isEmpty()) {
            return "/" + this.name + "/" + method;
        }
        return "/" + this.packageName + "." + this.name + "/" + method;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ServiceNameImpl that = (ServiceNameImpl)o;
        return Objects.equals(this.fullyQualifiedName(), that.fullyQualifiedName());
    }

    public int hashCode() {
        return Objects.hash(this.fullyQualifiedName());
    }
}

