/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.override;

import io.grpc.Context;
import io.vertx.core.Vertx;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import java.util.concurrent.ConcurrentMap;

public class ContextStorageOverride
extends Context.Storage {
    private static final Logger LOG = LoggerFactory.getLogger(ContextStorageOverride.class);
    private static final Object CONTEXT_KEY = new Object();
    private static final ThreadLocal<Context> fallback = new ThreadLocal();

    public Context doAttach(Context toAttach) {
        Context toRestoreLater;
        ContextInternal vertxContext = ContextStorageOverride.vertxContext();
        if (vertxContext != null) {
            toRestoreLater = vertxContext.localContextData().put(CONTEXT_KEY, toAttach);
        } else {
            toRestoreLater = fallback.get();
            fallback.set(toAttach);
        }
        return ContextStorageOverride.rootIfNull(toRestoreLater);
    }

    public void detach(Context toDetach, Context toRestore) {
        Context current;
        ContextInternal vertxContext = ContextStorageOverride.vertxContext();
        if (vertxContext != null) {
            ConcurrentMap dataMap = vertxContext.localContextData();
            current = toRestore == Context.ROOT ? (Context)dataMap.remove(CONTEXT_KEY) : dataMap.put(CONTEXT_KEY, toRestore);
        } else {
            current = fallback.get();
            fallback.remove();
            fallback.set(toRestore == Context.ROOT ? null : toRestore);
        }
        if (ContextStorageOverride.rootIfNull(current) != toDetach && LOG.isWarnEnabled()) {
            LOG.warn((Object)"Context was not attached when detaching", (Throwable)new Exception("Stack trace"));
        }
    }

    public Context current() {
        ContextInternal vertxContext = ContextStorageOverride.vertxContext();
        return ContextStorageOverride.rootIfNull(vertxContext != null ? (Context)vertxContext.getLocal(CONTEXT_KEY) : fallback.get());
    }

    private static ContextInternal vertxContext() {
        ContextInternal ctx = (ContextInternal)Vertx.currentContext();
        return ctx != null && ctx.isDuplicate() ? ctx : null;
    }

    private static Context rootIfNull(Context context) {
        return context == null ? Context.ROOT : context;
    }
}

